/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.handler.timeout.IdleState;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.Connection;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.network.listeners.MessageListener;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.HeartbeatMessage;
import pt.unl.fct.di.novasys.network.pipeline.MessageDecoder;
import pt.unl.fct.di.novasys.network.pipeline.MessageEncoder;

public abstract class ConnectionHandler<T>
extends ChannelDuplexHandler
implements Connection<T> {
    private static final Logger logger = LogManager.getLogger(ConnectionHandler.class);
    private final long connectionId;
    Host peer;
    Attributes peerAttributes;
    Attributes selfAttributes;
    MessageEncoder<T> encoder;
    MessageDecoder<T> decoder;
    Channel channel;
    EventLoop loop;
    private final MessageListener<T> consumer;
    private final boolean incoming;

    public ConnectionHandler(long connectionId, MessageListener<T> consumer, EventLoop loop, boolean incoming, Attributes selfAttrs) {
        this.connectionId = connectionId;
        this.consumer = consumer;
        this.incoming = incoming;
        this.selfAttributes = selfAttrs;
        this.loop = loop;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        NetworkMessage netMsg = (NetworkMessage)msg;
        if (netMsg.code == 0) {
            return;
        }
        this.consumer.deliverMessage(netMsg.payload, this);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                this.exceptionCaught(ctx, future.cause());
            }
        })));
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof IdleStateEvent) {
            IdleStateEvent e = (IdleStateEvent)evt;
            if (e.state() == IdleState.WRITER_IDLE) {
                ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new HeartbeatMessage()));
            } else if (e.state() == IdleState.READER_IDLE) {
                ctx.pipeline().fireExceptionCaught((Throwable)ReadTimeoutException.INSTANCE);
            }
        } else if (!(evt instanceof ChannelInputShutdownReadComplete)) {
            this.internalUserEventTriggered(ctx, evt);
        }
    }

    abstract void internalUserEventTriggered(ChannelHandlerContext var1, Object var2);

    @Override
    public final Host getPeer() {
        return this.peer;
    }

    @Override
    public final Attributes getPeerAttributes() {
        return this.peerAttributes;
    }

    @Override
    public final Attributes getSelfAttributes() {
        return this.selfAttributes;
    }

    @Override
    public boolean isInbound() {
        return this.incoming;
    }

    @Override
    public boolean isOutbound() {
        return !this.incoming;
    }

    @Override
    public EventLoop getLoop() {
        return this.loop;
    }

    @Override
    public long getSentAppBytes() {
        return this.encoder.getSentAppBytes();
    }

    @Override
    public long getSentAppMessages() {
        return this.encoder.getSentAppMessages();
    }

    @Override
    public long getSentControlBytes() {
        return this.encoder.getSentControlBytes();
    }

    @Override
    public long getSentControlMessages() {
        return this.encoder.getSentControlMessages();
    }

    @Override
    public long getReceivedAppBytes() {
        return this.decoder.getReceivedAppBytes();
    }

    @Override
    public long getReceivedAppMessages() {
        return this.decoder.getReceivedAppMessages();
    }

    @Override
    public long getReceivedControlBytes() {
        return this.decoder.getReceivedControlBytes();
    }

    @Override
    public long getReceivedControlMessages() {
        return this.decoder.getReceivedControlMessages();
    }

    @Override
    public long getConnectionId() {
        return this.connectionId;
    }
}

