/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.network.pipeline;

import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.fct.di.novasys.network.AttributeValidator;
import pt.unl.fct.di.novasys.network.data.Attributes;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeAttributesException;
import pt.unl.fct.di.novasys.network.exceptions.InvalidHandshakeException;
import pt.unl.fct.di.novasys.network.messaging.NetworkMessage;
import pt.unl.fct.di.novasys.network.messaging.control.ControlMessage;
import pt.unl.fct.di.novasys.network.messaging.control.FirstHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.InvalidAttributesMessage;
import pt.unl.fct.di.novasys.network.messaging.control.NthHandshakeMessage;
import pt.unl.fct.di.novasys.network.messaging.control.SecondHandshakeMessage;
import pt.unl.fct.di.novasys.network.userevents.HandshakeCompleted;

public class OutHandshakeHandler
extends ChannelDuplexHandler {
    private static final Logger logger = LogManager.getLogger(OutHandshakeHandler.class);
    private final long connectionId;
    private final AttributeValidator validator;
    private final List<Attributes> peerAttrs;
    private final List<Attributes> myAttrs;
    private final int handshakeSteps;

    public OutHandshakeHandler(long connectionId, AttributeValidator validator, Attributes myAttrs, int handshakeSteps) {
        this.connectionId = connectionId;
        this.validator = validator;
        this.myAttrs = new ArrayList<Attributes>((handshakeSteps + 1) / 2);
        this.myAttrs.add(myAttrs);
        this.peerAttrs = new ArrayList<Attributes>(handshakeSteps / 2);
        this.handshakeSteps = handshakeSteps;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new FirstHandshakeMessage(this.myAttrs.getFirst())));
        ctx.fireChannelActive();
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        ctx.write(msg, promise.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE));
    }

    public void channelRead(ChannelHandlerContext ctx, Object obj) throws Exception {
        NetworkMessage msg = (NetworkMessage)obj;
        if (msg.code != 0) {
            throw new Exception("Received application message in outHandshake: " + String.valueOf(msg));
        }
        try {
            ControlMessage cMsg = (ControlMessage)msg.payload;
            switch (cMsg.type) {
                case HEARTBEAT: {
                    return;
                }
                case SECOND_HS: {
                    this.handleSecondHandshakeMessage(ctx, (SecondHandshakeMessage)cMsg);
                    break;
                }
                case NTH_HS: {
                    this.handleNthHandshakeMessage(ctx, (NthHandshakeMessage)cMsg);
                    break;
                }
                case INVALID_ATTR: {
                    throw new Exception("Attributes refused");
                }
                default: {
                    throw new Exception("Received unexpected control message in outHandshake: " + String.valueOf(msg));
                }
            }
        }
        catch (InvalidHandshakeAttributesException e) {
            ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new InvalidAttributesMessage()));
            throw e;
        }
    }

    private void handleSecondHandshakeMessage(ChannelHandlerContext ctx, SecondHandshakeMessage shm) throws InvalidHandshakeException {
        this.peerAttrs.add(shm.attributes);
        byte nextStep = 3;
        Attributes replyAttrs = this.validator.getNthHandshakeAttributes(this.connectionId, nextStep, this.peerAttrs, this.myAttrs);
        if (this.handshakeSteps > 2) {
            this.myAttrs.add(replyAttrs);
            ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new NthHandshakeMessage(replyAttrs, nextStep)));
        }
        if (this.handshakeSteps == 2 || this.handshakeSteps == 3) {
            ctx.fireUserEventTriggered((Object)new HandshakeCompleted(shm.attributes));
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    private void handleNthHandshakeMessage(ChannelHandlerContext ctx, NthHandshakeMessage nhm) throws InvalidHandshakeException {
        if (nhm.handshakeStep / 2 != this.myAttrs.size()) {
            throw new InvalidHandshakeException("Invalid NthHandshakeMessage step for OutHandshakeHandler: " + nhm.handshakeStep);
        }
        this.peerAttrs.add(nhm.attributes);
        int nextStep = nhm.handshakeStep + 1;
        Attributes replyAttrs = this.validator.getNthHandshakeAttributes(this.connectionId, nextStep, this.peerAttrs, this.myAttrs);
        if (nextStep <= this.handshakeSteps) {
            this.myAttrs.add(replyAttrs);
            ctx.channel().writeAndFlush((Object)new NetworkMessage(0, new NthHandshakeMessage(replyAttrs, nextStep)));
        }
        if (this.handshakeSteps == nhm.handshakeStep || this.handshakeSteps == nextStep) {
            Attributes finalPeerAttributes = new Attributes();
            for (Attributes attr : this.peerAttrs) {
                finalPeerAttributes.putAll(attr);
            }
            ctx.fireUserEventTriggered((Object)new HandshakeCompleted(finalPeerAttributes));
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }
}

