/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.entropyhybrid.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.crdts.delta.causal.generic.DeltaCausalCRDT;
import pt.unl.fct.di.novasys.babel.crdts.generic.GenericCRDT;
import pt.unl.fct.di.novasys.babel.crdts.utils.CRDTsTypes;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.storage.utils.Utils;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class DeltaMessage
extends ProtoMessage {
    public static final short MSG_CODE = 603;
    private DeltaCausalCRDT delta;
    private int seqNumber;
    private Host origin;
    private String collectionID;
    private Host destination;
    public static final ISerializer<DeltaMessage> serializer = new ISerializer<DeltaMessage>(){

        public void serialize(DeltaMessage msg, ByteBuf out) throws IOException {
            Utils.encodeUTF8((String)msg.collectionID, (ByteBuf)out);
            out.writeInt(msg.seqNumber);
            Host.serializer.serialize((Object)msg.origin, out);
            Host.serializer.serialize((Object)msg.destination, out);
            CRDTsTypes.serializer.serialize((Object)msg.delta.getType(), out);
            msg.delta.serialize(out);
        }

        public DeltaMessage deserialize(ByteBuf in) throws IOException {
            String collectionID = Utils.decodeUTF8((ByteBuf)in);
            int seqNumber = in.readInt();
            Host origin = (Host)Host.serializer.deserialize(in);
            Host destination = (Host)Host.serializer.deserialize(in);
            CRDTsTypes type = (CRDTsTypes)CRDTsTypes.serializer.deserialize(in);
            if (!type.isOfFlavor(CRDTsTypes.FLAVOR.DELTA)) {
                throw new IOException("CRDT received is not delta-based!");
            }
            DeltaCausalCRDT delta = (DeltaCausalCRDT)GenericCRDT.deserializeDataType((CRDTsTypes)type, (ByteBuf)in);
            return new DeltaMessage(collectionID, delta, seqNumber, origin, destination);
        }
    };

    public DeltaMessage(String objectID, DeltaCausalCRDT delta, int seqNumber, Host origin, Host destination) {
        super((short)603);
        this.delta = delta;
        this.seqNumber = seqNumber;
        this.origin = origin;
        this.collectionID = objectID;
        this.destination = destination;
    }

    public DeltaCausalCRDT getDelta() {
        return this.delta;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public Host getOrigin() {
        return this.origin;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public Host getDestination() {
        return this.destination;
    }
}

