/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.entropyhybrid.utils;

import java.util.Collections;
import java.util.SortedMap;
import java.util.TreeMap;
import pt.unl.di.novasys.babel.nimbus.rc.entropyhybrid.utils.DeltaBuffer;
import pt.unl.fct.di.novasys.babel.crdts.delta.causal.generic.DeltaCausalCRDT;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusID;

public class DeltaState {
    private SortedMap<Integer, DeltaBuffer> buffer;
    private SortedMap<Host, Integer> acks;
    private int seqNumber;
    private String collectionID;

    public DeltaState(String collectionID) {
        this.collectionID = collectionID;
        this.buffer = new TreeMap<Integer, DeltaBuffer>();
        this.acks = new TreeMap<Host, Integer>();
        this.seqNumber = 0;
    }

    public DeltaState(String collectionID, int seqNumber) {
        this.collectionID = collectionID;
        this.buffer = new TreeMap<Integer, DeltaBuffer>();
        this.acks = new TreeMap<Host, Integer>();
        this.seqNumber = seqNumber;
    }

    public SortedMap<Integer, DeltaBuffer> getBuffer() {
        return this.buffer;
    }

    public DeltaBuffer getDeltaBuffer(int seqNumber) {
        return (DeltaBuffer)this.buffer.get(seqNumber);
    }

    public DeltaCausalCRDT getCRDT(int seqNumber) {
        return ((DeltaBuffer)this.buffer.get(seqNumber)).getDelta();
    }

    public void putCRDT(NimbusID crdtID, DeltaCausalCRDT crdt, Host origin) {
        this.buffer.put(this.seqNumber, new DeltaBuffer(crdtID, crdt, origin));
        this.incSeqNumber();
    }

    public int getMinBufferSeqNum() {
        if (this.buffer.isEmpty()) {
            return -1;
        }
        return this.buffer.firstKey();
    }

    public int getMaxBufferSeqNum() {
        if (this.buffer.isEmpty()) {
            return -1;
        }
        return this.buffer.lastKey();
    }

    public SortedMap<Host, Integer> getAcks() {
        return this.acks;
    }

    public int minAck() {
        if (this.acks.values().isEmpty()) {
            return -1;
        }
        return Collections.min(this.acks.values());
    }

    public int hostsWithAck(int ack) {
        if (this.acks.values().isEmpty()) {
            return -1;
        }
        int count = 0;
        for (int ackValue : this.acks.values()) {
            if (ack != ackValue) continue;
            ++count;
        }
        return count;
    }

    public Integer getACK(Host peer) {
        Integer ack = (Integer)this.acks.get(peer);
        return ack == null ? -1 : ack;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public void incSeqNumber() {
        ++this.seqNumber;
    }

    public void updateAcks(Host origin, int ackSeqNumber) {
        int maxSeqNumber = Math.max(ackSeqNumber, this.getACK(origin));
        this.acks.put(origin, maxSeqNumber);
    }
}

