/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.entropypush.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.storage.utils.Utils;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;

public class AckMessage
extends ProtoMessage {
    public static final short MSG_CODE = 602;
    private int seqNumber;
    private Host origin;
    private String collectionID;
    public static final ISerializer<AckMessage> serializer = new ISerializer<AckMessage>(){

        public void serialize(AckMessage msg, ByteBuf out) throws IOException {
            out.writeInt(msg.getSeqNumber());
            Host.serializer.serialize((Object)msg.getOrigin(), out);
            Utils.encodeUTF8((String)msg.collectionID, (ByteBuf)out);
        }

        public AckMessage deserialize(ByteBuf in) throws IOException {
            int seqNumber = in.readInt();
            Host origin = (Host)Host.serializer.deserialize(in);
            String collectionID = Utils.decodeUTF8((ByteBuf)in);
            return new AckMessage(collectionID, seqNumber, origin);
        }
    };

    public AckMessage(String objectID, int seqNumber, Host origin) {
        super((short)602);
        this.collectionID = objectID;
        this.seqNumber = seqNumber;
        this.origin = origin;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public Host getOrigin() {
        return this.origin;
    }

    public String getCollectionID() {
        return this.collectionID;
    }
}

