/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusID;

public class AckMessage
extends ProtoMessage {
    public static final short MSG_CODE = 6400;
    private int seqNumber;
    private Host origin;
    private NimbusID nimbusID;
    public static final ISerializer<AckMessage> serializer = new ISerializer<AckMessage>(){

        public void serialize(AckMessage msg, ByteBuf out) throws IOException {
            out.writeInt(msg.getSeqNumber());
            Host.serializer.serialize((Object)msg.getOrigin(), out);
            NimbusID.serializer.serialize((Object)msg.nimbusID, out);
        }

        public AckMessage deserialize(ByteBuf in) throws IOException {
            int seqNumber = in.readInt();
            Host origin = (Host)Host.serializer.deserialize(in);
            NimbusID nimbusID = (NimbusID)NimbusID.serializer.deserialize(in);
            return new AckMessage(nimbusID, seqNumber, origin);
        }
    };

    public AckMessage(NimbusID nimbusID, int seqNumber, Host origin) {
        super((short)6400);
        this.nimbusID = nimbusID;
        this.seqNumber = seqNumber;
        this.origin = origin;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public Host getOrigin() {
        return this.origin;
    }

    public NimbusID getNimbusID() {
        return this.nimbusID;
    }
}

