/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.crdts.delta.causal.generic.DeltaCausalCRDT;
import pt.unl.fct.di.novasys.babel.crdts.generic.GenericCRDT;
import pt.unl.fct.di.novasys.babel.crdts.utils.CRDTsTypes;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.network.data.Host;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusID;

public class DeltaMessage
extends ProtoMessage {
    public static final short MSG_CODE = 6401;
    private DeltaCausalCRDT delta;
    private int seqNumber;
    private Host origin;
    private NimbusID nimbusID;
    public static final ISerializer<DeltaMessage> serializer = new ISerializer<DeltaMessage>(){

        public void serialize(DeltaMessage msg, ByteBuf out) throws IOException {
            NimbusID.serializer.serialize((Object)msg.nimbusID, out);
            out.writeInt(msg.seqNumber);
            Host.serializer.serialize((Object)msg.origin, out);
            CRDTsTypes.serializer.serialize((Object)msg.delta.getType(), out);
            msg.delta.serialize(out);
        }

        public DeltaMessage deserialize(ByteBuf in) throws IOException {
            NimbusID nimbusID = (NimbusID)NimbusID.serializer.deserialize(in);
            int seqNumber = in.readInt();
            Host origin = (Host)Host.serializer.deserialize(in);
            CRDTsTypes type = (CRDTsTypes)CRDTsTypes.serializer.deserialize(in);
            if (!type.isOfFlavor(CRDTsTypes.FLAVOR.DELTA)) {
                throw new IOException("CRDT received is not delta-based!");
            }
            DeltaCausalCRDT delta = (DeltaCausalCRDT)GenericCRDT.deserializeDataType((CRDTsTypes)type, (ByteBuf)in);
            return new DeltaMessage(nimbusID, delta, seqNumber, origin);
        }
    };

    public DeltaMessage(NimbusID nimbusID, DeltaCausalCRDT delta, int seqNumber, Host origin) {
        super((short)6401);
        this.delta = delta;
        this.seqNumber = seqNumber;
        this.origin = origin;
        this.nimbusID = nimbusID;
    }

    public DeltaCausalCRDT getDelta() {
        return this.delta;
    }

    public int getSeqNumber() {
        return this.seqNumber;
    }

    public Host getOrigin() {
        return this.origin;
    }

    public NimbusID getNimbusID() {
        return this.nimbusID;
    }
}

