/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import pt.unl.fct.di.novasys.babel.crdts.delta.causal.generic.DeltaCausalCRDT;
import pt.unl.fct.di.novasys.babel.crdts.generic.GenericCRDT;
import pt.unl.fct.di.novasys.babel.crdts.utils.CRDTsTypes;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.storage.operations.utils.CommonOperationStatus;
import pt.unl.fct.di.novasys.babel.protocols.storage.utils.Utils;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusID;

public class RemoteOperationResultMessage
extends ProtoMessage {
    public static final short MSG_CODE = 6403;
    private NimbusID nimbusID;
    private CommonOperationStatus status;
    private DeltaCausalCRDT crdt;
    private String message;
    public static final ISerializer<RemoteOperationResultMessage> serializer = new ISerializer<RemoteOperationResultMessage>(){

        public void serialize(RemoteOperationResultMessage msg, ByteBuf out) throws IOException {
            NimbusID.serializer.serialize((Object)msg.nimbusID, out);
            CommonOperationStatus.serializer.serialize((Object)msg.status, out);
            out.writeBoolean(msg.crdt != null);
            if (msg.crdt != null) {
                CRDTsTypes.serializer.serialize((Object)msg.crdt.getType(), out);
                msg.crdt.serialize(out);
            }
            Utils.encodeUTF8((String)msg.getMessage(), (ByteBuf)out);
        }

        public RemoteOperationResultMessage deserialize(ByteBuf in) throws IOException {
            NimbusID nimbusID = (NimbusID)NimbusID.serializer.deserialize(in);
            CommonOperationStatus status = (CommonOperationStatus)CommonOperationStatus.serializer.deserialize(in);
            boolean hasCRDT = in.readBoolean();
            DeltaCausalCRDT crdt = null;
            if (hasCRDT) {
                CRDTsTypes type = (CRDTsTypes)CRDTsTypes.serializer.deserialize(in);
                if (!type.isOfFlavor(CRDTsTypes.FLAVOR.DELTA)) {
                    throw new IOException("CRDT received is not delta-based!");
                }
                crdt = (DeltaCausalCRDT)GenericCRDT.deserializeDataType((CRDTsTypes)type, (ByteBuf)in);
            }
            String message = Utils.decodeUTF8((ByteBuf)in);
            return new RemoteOperationResultMessage(nimbusID, status, crdt, message);
        }
    };

    public RemoteOperationResultMessage(NimbusID nimbusID, CommonOperationStatus status, DeltaCausalCRDT crdt, String message) {
        super((short)6403);
        this.nimbusID = nimbusID;
        this.status = status;
        this.crdt = crdt;
        this.message = message;
    }

    public NimbusID getNimbusID() {
        return this.nimbusID;
    }

    public DeltaCausalCRDT getCRDT() {
        return this.crdt;
    }

    public CommonOperationStatus getStatus() {
        return this.status;
    }

    public String getMessage() {
        return this.message;
    }
}

