/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.messages;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import pt.unl.fct.di.novasys.babel.crdts.delta.causal.implementations.DeltaOORMap;
import pt.unl.fct.di.novasys.babel.crdts.generic.GenericCRDT;
import pt.unl.fct.di.novasys.babel.crdts.utils.CRDTsTypes;
import pt.unl.fct.di.novasys.babel.generic.ProtoMessage;
import pt.unl.fct.di.novasys.babel.protocols.storage.utils.Utils;
import pt.unl.fct.di.novasys.network.ISerializer;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusID;

public class RemoteStateResultMessage
extends ProtoMessage {
    public static final short MSG_CODE = 6405;
    private NimbusID nimbusID;
    private Map<String, DeltaOORMap> collections;
    public static final ISerializer<RemoteStateResultMessage> serializer = new ISerializer<RemoteStateResultMessage>(){

        public void serialize(RemoteStateResultMessage msg, ByteBuf out) throws IOException {
            NimbusID.serializer.serialize((Object)msg.nimbusID, out);
            out.writeInt(msg.collections.size());
            for (Map.Entry<String, DeltaOORMap> pair : msg.collections.entrySet()) {
                String collectionID = pair.getKey();
                DeltaOORMap collection = pair.getValue();
                Utils.encodeUTF8((String)collectionID, (ByteBuf)out);
                CRDTsTypes.serializer.serialize((Object)collection.getType(), out);
                collection.serialize(out);
            }
        }

        public RemoteStateResultMessage deserialize(ByteBuf in) throws IOException {
            NimbusID nimbusID = (NimbusID)NimbusID.serializer.deserialize(in);
            int size = in.readInt();
            HashMap<String, DeltaOORMap> collections = new HashMap<String, DeltaOORMap>(size);
            for (int i = 0; i < size; ++i) {
                String collectionID = Utils.decodeUTF8((ByteBuf)in);
                CRDTsTypes type = (CRDTsTypes)CRDTsTypes.serializer.deserialize(in);
                if (!type.isOfFlavor(CRDTsTypes.FLAVOR.DELTA)) {
                    throw new IOException("CRDT received is not delta-based!");
                }
                DeltaOORMap crdt = (DeltaOORMap)GenericCRDT.deserializeDataType((CRDTsTypes)type, (ByteBuf)in);
                collections.put(collectionID, crdt);
            }
            return new RemoteStateResultMessage(nimbusID, collections);
        }
    };

    public RemoteStateResultMessage(NimbusID nimbusID, Map<String, DeltaOORMap> collections) {
        super((short)6405);
        this.nimbusID = nimbusID;
        this.collections = collections;
    }

    public Map<String, DeltaOORMap> getCollections() {
        return this.collections;
    }

    public NimbusID getNimbusID() {
        return this.nimbusID;
    }
}

