/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.structures;

import java.util.HashSet;
import java.util.Set;
import pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.utils.DeltaState;
import pt.unl.fct.di.novasys.babel.crdts.utils.ReplicaID;

public class ReplicationCoreCollection {
    private String collectionID;
    private DeltaState deltas;
    private Set<ReplicaID> replicas;

    public ReplicationCoreCollection(String collectionID) {
        this.collectionID = collectionID;
        this.replicas = new HashSet<ReplicaID>();
        this.deltas = null;
    }

    public ReplicationCoreCollection(String collectionID, Set<ReplicaID> replicas) {
        this.collectionID = collectionID;
        this.replicas = replicas;
        this.deltas = null;
    }

    public String getCollectionID() {
        return this.collectionID;
    }

    public Set<ReplicaID> getReplicas() {
        return this.replicas;
    }

    public void addReplica(ReplicaID node) {
        this.replicas.add(node);
    }

    public boolean removeReplica(ReplicaID node) {
        return this.replicas.remove(node);
    }

    public void replaceReplicas(Set<ReplicaID> replicas) {
        this.replicas.clear();
        this.replicas.addAll(replicas);
    }

    public boolean isReplica(ReplicaID node) {
        return this.replicas.contains(node);
    }

    public DeltaState getDeltaState() {
        if (this.deltas == null) {
            this.deltas = new DeltaState(this.collectionID);
        }
        return this.deltas;
    }
}

