/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.structures;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.structures.ReplicationCoreCollection;
import pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.utils.DeltaState;
import pt.unl.fct.di.novasys.babel.crdts.utils.ReplicaID;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusUtils;
import pt.unl.fct.di.novasys.nimbus.utils.exceptions.CollectionNotFoundException;

public class ReplicationCoreKeySpace {
    private Map<String, ReplicationCoreCollection> collections;
    private Set<ReplicaID> replicas;
    private String keySpaceID;

    ReplicationCoreKeySpace(String keySpaceID) {
        this.keySpaceID = keySpaceID;
        this.replicas = new HashSet<ReplicaID>();
        this.collections = new HashMap<String, ReplicationCoreCollection>();
    }

    public ReplicationCoreKeySpace(String keySpaceID, Set<ReplicaID> replicas) {
        this.keySpaceID = keySpaceID;
        this.replicas = replicas;
        this.collections = new HashMap<String, ReplicationCoreCollection>();
    }

    public String getKeySpaceID() {
        return this.keySpaceID;
    }

    public Set<ReplicaID> getReplicas() {
        return this.replicas;
    }

    public boolean containsCollection(String collectionID) {
        return this.collections.containsKey(collectionID);
    }

    public void addReplica(ReplicaID node) {
        this.replicas.add(node);
    }

    public boolean removeReplica(ReplicaID node) {
        return this.replicas.remove(node);
    }

    public void replaceReplicas(Set<ReplicaID> replicas) {
        this.replicas.clear();
        this.replicas.addAll(replicas);
    }

    public boolean isReplica(ReplicaID node) {
        return this.replicas.contains(node);
    }

    public void addReplica(String collectionID, ReplicaID node) throws CollectionNotFoundException {
        if (!this.containsCollection(collectionID)) {
            this.innerCreateCollection(collectionID);
        }
        this.collections.get(collectionID).addReplica(node);
    }

    public boolean removeReplica(String collectionID, ReplicaID node) throws CollectionNotFoundException {
        if (!this.containsCollection(collectionID)) {
            this.innerCreateCollection(collectionID);
        }
        return this.collections.get(collectionID).removeReplica(node);
    }

    public void replaceReplicas(String collectionID, Set<ReplicaID> replicas) {
        if (!this.containsCollection(collectionID)) {
            this.innerCreateCollection(collectionID);
        }
        this.collections.get(collectionID).replaceReplicas(replicas);
    }

    private void innerCreateCollection(String collectionID) {
        if (this.containsCollection(collectionID)) {
            return;
        }
        this.collections.put(collectionID, new ReplicationCoreCollection(collectionID));
    }

    public void createCollection(String collectionID, Set<ReplicaID> replicas) {
        if (this.containsCollection(collectionID)) {
            return;
        }
        this.collections.put(collectionID, new ReplicationCoreCollection(collectionID, replicas));
    }

    public void removeCollection(String collectionID) {
        if (!this.containsCollection(collectionID)) {
            return;
        }
        this.collections.remove(collectionID);
    }

    public DeltaState getDeltaState(String collectionID) {
        if (!this.containsCollection(collectionID)) {
            this.innerCreateCollection(collectionID);
        }
        return this.collections.get(collectionID).getDeltaState();
    }

    public void garbageCollectDeltas(int minGCAcks) {
        for (ReplicationCoreCollection collection : this.collections.values()) {
            int hostsWithMinAck;
            int minFanout = Math.min(collection.getReplicas().size(), minGCAcks);
            DeltaState state = collection.getDeltaState();
            int lowestAck = state.minAck();
            if (lowestAck == -1 || (hostsWithMinAck = state.hostsWithAck(lowestAck)) < minFanout) continue;
            state.getBuffer().keySet().removeIf(seqNumber -> seqNumber < lowestAck);
        }
    }

    public Map<String, ReplicationCoreCollection> getCollections() {
        return this.collections;
    }

    public ReplicaID getReplicaFrom(String collectionID, ReplicaID myself) {
        if (!this.containsCollection(collectionID)) {
            this.innerCreateCollection(collectionID);
        }
        ReplicationCoreCollection collection = this.collections.get(collectionID);
        return (ReplicaID)NimbusUtils.randomExcept(collection.getReplicas(), (Object)myself);
    }
}

