/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.structures;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.structures.ReplicationCoreKeySpace;
import pt.unl.di.novasys.babel.nimbus.rc.partialentropypush.utils.DeltaState;
import pt.unl.fct.di.novasys.babel.crdts.utils.ReplicaID;
import pt.unl.fct.di.novasys.nimbus.utils.common.NimbusUtils;
import pt.unl.fct.di.novasys.nimbus.utils.exceptions.KeyspaceAlreadyExistsException;
import pt.unl.fct.di.novasys.nimbus.utils.exceptions.KeyspaceNotFoundException;

public class ReplicationCoreManager {
    private static final Logger logger = LogManager.getLogger(ReplicationCoreManager.class);
    private ReplicaID myself;
    private Map<String, ReplicationCoreKeySpace> keySpaces;

    public ReplicationCoreManager(ReplicaID myself) {
        this.myself = myself;
        this.keySpaces = new HashMap<String, ReplicationCoreKeySpace>();
    }

    public boolean containsKeySpace(String keySpaceID) {
        return this.keySpaces.containsKey(keySpaceID);
    }

    private void innerCreateKeySpace(String keySpaceID) {
        if (this.containsKeySpace(keySpaceID)) {
            return;
        }
        this.keySpaces.put(keySpaceID, new ReplicationCoreKeySpace(keySpaceID));
    }

    public void createKeyspace(String keySpaceID, Set<ReplicaID> replicas) {
        if (this.containsKeySpace(keySpaceID)) {
            return;
        }
        this.keySpaces.put(keySpaceID, new ReplicationCoreKeySpace(keySpaceID, replicas));
    }

    public void removeKeySpace(String keySpaceID) {
        if (!this.containsKeySpace(keySpaceID)) {
            return;
        }
        this.keySpaces.remove(keySpaceID);
    }

    public void createCollection(String keySpaceID, String collectionID, Set<ReplicaID> replicas) {
        if (!this.containsKeySpace(keySpaceID)) {
            return;
        }
        this.keySpaces.get(keySpaceID).createCollection(collectionID, replicas);
    }

    public void removeCollection(String keySpaceID, String collectionID) {
        if (this.containsKeySpace(keySpaceID)) {
            throw new KeyspaceAlreadyExistsException(keySpaceID);
        }
        this.keySpaces.get(keySpaceID).removeCollection(collectionID);
    }

    public void addReplicas(String keySpaceID, Set<ReplicaID> replicas) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        for (ReplicaID replica : replicas) {
            this.keySpaces.get(keySpaceID).addReplica(replica);
        }
    }

    public void removeReplicas(String keySpaceID, Set<ReplicaID> replicas) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        for (ReplicaID replica : replicas) {
            this.keySpaces.get(keySpaceID).removeReplica(replica);
        }
    }

    public void replaceReplicas(String keySpaceID, Set<ReplicaID> replicas) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        this.keySpaces.get(keySpaceID).replaceReplicas(replicas);
    }

    public void addReplicas(String keySpaceID, String collectionID, Set<ReplicaID> replicas) throws KeyspaceNotFoundException {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        for (ReplicaID replica : replicas) {
            this.keySpaces.get(keySpaceID).addReplica(collectionID, replica);
        }
    }

    public void removeReplicas(String keySpaceID, String collectionID, Set<ReplicaID> replicas) throws KeyspaceNotFoundException {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        for (ReplicaID replica : replicas) {
            this.keySpaces.get(keySpaceID).removeReplica(collectionID, replica);
        }
    }

    public void replaceReplicas(String keySpaceID, String collectionID, Set<ReplicaID> replicas) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        this.keySpaces.get(keySpaceID).replaceReplicas(collectionID, replicas);
    }

    public DeltaState getDeltaState(String keySpaceID, String collectionID) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        return this.keySpaces.get(keySpaceID).getDeltaState(collectionID);
    }

    public void garbageCollectDeltas(int minGCAcks) {
        for (ReplicationCoreKeySpace keyspace : this.keySpaces.values()) {
            keyspace.garbageCollectDeltas(minGCAcks);
        }
    }

    public Map<String, ReplicationCoreKeySpace> getKeySpaces() {
        return this.keySpaces;
    }

    public ReplicaID getReplicaFrom(String keySpaceID, String collectionID) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        return this.keySpaces.get(keySpaceID).getReplicaFrom(collectionID, this.myself);
    }

    public ReplicaID getReplicaFrom(String keySpaceID) {
        if (!this.containsKeySpace(keySpaceID)) {
            this.innerCreateKeySpace(keySpaceID);
        }
        return (ReplicaID)NimbusUtils.randomExcept(this.keySpaces.get(keySpaceID).getReplicas(), (Object)this.myself);
    }
}

