/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.p2psim.controls.broadcast.observer;

import java.util.HashMap;
import java.util.Map;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Network;
import peernet.core.Node;
import peernet.reports.FileObserver;
import peernet.util.IncrementalFreq;
import pt.unl.fct.di.novasys.p2psim.controls.broadcast.interfaces.BroadcastCapable;
import pt.unl.fct.di.novasys.p2psim.controls.broadcast.interfaces.DeliveryRecord;

public class BCastStatisticsObserver
extends FileObserver {
    private int broadcastProtoId;

    public BCastStatisticsObserver(String prefix) {
        super(prefix);
        this.broadcastProtoId = Configuration.getPid((String)(prefix + ".protocol"));
    }

    public boolean execute() {
        System.err.println(CommonState.getTime() + ": " + ((Object)((Object)this)).getClass().getName() + " extracting broadcast statistics.");
        this.startObservation();
        int aliveNodes = 0;
        HashMap<Long, BCastMessageStatistics> stats = new HashMap<Long, BCastMessageStatistics>();
        for (int i = 0; i < Network.size(); ++i) {
            Node n = Network.get((int)i);
            if (n.isUp()) {
                ++aliveNodes;
            }
            BroadcastCapable b = (BroadcastCapable)n.getProtocol(this.broadcastProtoId);
            Map<Long, Long> sentMessages = b.getSentMessages();
            Map<Long, DeliveryRecord> deliveryMessages = b.getDeliveredMessages();
            for (Long msg : sentMessages.keySet()) {
                if (!stats.containsKey(msg)) {
                    stats.put(msg, new BCastMessageStatistics());
                }
                ((BCastMessageStatistics)stats.get((Object)msg)).timeSent = sentMessages.get(msg);
            }
            for (Long msg : deliveryMessages.keySet()) {
                if (!stats.containsKey(msg)) {
                    stats.put(msg, new BCastMessageStatistics());
                }
                BCastMessageStatistics bcms = (BCastMessageStatistics)stats.get(msg);
                DeliveryRecord dr = deliveryMessages.get(msg);
                ++bcms.countdelivery;
                bcms.deliveryTimes.add((int)dr.getDeliveryTime());
                bcms.deliveryHops.add((int)dr.getDeliveryHop());
            }
            b.resetMetrics();
        }
        for (Long msgID : stats.keySet()) {
            BCastMessageStatistics bcms = (BCastMessageStatistics)stats.get(msgID);
            this.output(msgID + this.separator + bcms.timeSent + this.separator + ((long)bcms.deliveryTimes.getMax() - bcms.timeSent) + this.separator + (bcms.deliveryTimes.getAverage() - (double)bcms.timeSent) + this.separator + bcms.deliveryHops.getMax() + this.separator + bcms.deliveryHops.getAverage() + this.separator + bcms.countdelivery + this.separator + (double)bcms.countdelivery / (double)aliveNodes * 100.0);
        }
        this.stopObservation();
        return false;
    }

    private class BCastMessageStatistics {
        public int countdelivery = 0;
        public long timeSent = 0L;
        public IncrementalFreq deliveryTimes = new IncrementalFreq();
        public IncrementalFreq deliveryHops = new IncrementalFreq();

        protected BCastMessageStatistics() {
        }
    }
}

