/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.p2psim.controls.overlay;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.Network;
import peernet.core.Peer;
import pt.unl.fct.di.novasys.p2psim.protocols.overlay.ContactBasedInitilizable;

public class OverlayJoinControl
implements Control {
    static final String NODES_TO_ACTIVATE = "nodes";
    static final String CONTACT_SELECTION = "selector";
    private int protocolID;
    private int nodes;
    private SELECTOR selector;
    private int activated;

    public OverlayJoinControl(String prefix) {
        String selectorType;
        this.protocolID = Configuration.getPid((String)(prefix + ".protocol"));
        this.nodes = Configuration.getInt((String)(prefix + ".nodes"), (int)1);
        switch (selectorType = Configuration.getString((String)(prefix + ".selector"), (String)"single")) {
            case "single": {
                this.selector = SELECTOR.SINGLE;
                break;
            }
            case "random": {
                this.selector = SELECTOR.RANDOM;
                break;
            }
            case "line": {
                this.selector = SELECTOR.LINE;
                break;
            }
            default: {
                System.err.println("Invalid selector type: " + selectorType);
            }
        }
        this.activated = 1;
    }

    public boolean execute() {
        int target = this.activated + this.nodes;
        Peer contact = null;
        if (this.selector == SELECTOR.SINGLE) {
            contact = new Peer(Network.getByID((long)0L), 0);
        }
        while (this.activated < target) {
            if (this.selector == SELECTOR.RANDOM) {
                contact = new Peer(Network.getByID((long)CommonState.r.nextInt(this.activated)), 0);
            } else if (this.selector == SELECTOR.LINE) {
                contact = new Peer(Network.getByID((long)(this.activated - 1)), 0);
            }
            ((ContactBasedInitilizable)Network.getByID((long)this.activated).getProtocol(this.protocolID)).triggerJoinMechanism(contact);
            ++this.activated;
        }
        return false;
    }

    static enum SELECTOR {
        SINGLE,
        RANDOM,
        LINE;

    }
}

