/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.p2psim.controls.overlay;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.Network;
import peernet.core.Node;
import peernet.core.Peer;
import peernet.dynamics.NodeInitializer;
import pt.unl.fct.di.novasys.p2psim.protocols.overlay.ContactBasedInitilizable;

public class OverlayJoinInitializer
implements NodeInitializer,
Control {
    static final String PAR_PROTOCOL = "protocol";
    static final String CONTACT_SELECTION = "selector";
    private int protocolID;
    private SELECTOR selector;

    public OverlayJoinInitializer(String prefix) {
        String selectorType;
        this.protocolID = Configuration.getPid((String)(prefix + ".protocol"));
        switch (selectorType = Configuration.getString((String)(prefix + ".selector"), (String)"single")) {
            case "single": {
                this.selector = SELECTOR.SINGLE;
                break;
            }
            case "random": {
                this.selector = SELECTOR.RANDOM;
                break;
            }
            case "line": {
                this.selector = SELECTOR.LINE;
                break;
            }
            default: {
                System.err.println("Invalid selector type: " + selectorType);
            }
        }
    }

    public void initialize(Node n) {
        Peer contact = null;
        if (this.selector == SELECTOR.SINGLE) {
            contact = new Peer(Network.get((int)0), 0);
        } else if (this.selector == SELECTOR.RANDOM) {
            contact = new Peer(Network.get((int)CommonState.r.nextInt(Network.size())), 0);
        } else if (this.selector == SELECTOR.LINE) {
            contact = new Peer(Network.get((int)(Network.size() - 1)), 0);
        }
        ((ContactBasedInitilizable)n.getProtocol(this.protocolID)).triggerJoinMechanism(contact);
    }

    public boolean execute() {
        Peer contact = null;
        if (this.selector == SELECTOR.SINGLE) {
            contact = new Peer(Network.get((int)0), 0);
        }
        for (int activated = 1; activated < Network.size(); ++activated) {
            if (this.selector == SELECTOR.RANDOM) {
                contact = new Peer(Network.get((int)CommonState.r.nextInt(activated)), 0);
            } else if (this.selector == SELECTOR.LINE) {
                contact = new Peer(Network.get((int)(activated - 1)), 0);
            }
            ((ContactBasedInitilizable)Network.get((int)activated).getProtocol(this.protocolID)).triggerJoinMechanism(contact);
        }
        return false;
    }

    static enum SELECTOR {
        SINGLE,
        RANDOM,
        LINE;

    }
}

