/*
 * Decompiled with CFR 0.152.
 */
package pt.unl.fct.di.novasys.p2psim.protocols.overlay.observers;

import java.util.HashMap;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Linkable;
import peernet.core.Network;
import peernet.core.Node;
import peernet.reports.FileObserver;
import peernet.util.IncrementalFreq;

public class InDegreeObserver
extends FileObserver {
    private int linkableProtoId;

    public InDegreeObserver(String prefix) {
        super(prefix);
        this.linkableProtoId = Configuration.getPid((String)(prefix + ".protocol"));
    }

    public boolean execute() {
        System.err.println(CommonState.getTime() + ": " + ((Object)((Object)this)).getClass().getName() + " extracting in-degree distribution statistics.");
        this.startObservation();
        HashMap<Node, Integer> indegree = new HashMap<Node, Integer>();
        for (int i = 0; i < Network.size(); ++i) {
            Node n = Network.get((int)i);
            if (!n.isUp()) continue;
            Linkable l = (Linkable)n.getProtocol(this.linkableProtoId);
            for (int j = 0; j < l.degree(); ++j) {
                Node n2 = Network.getByID((long)l.getNeighbor(j).getID());
                if (n2 == null || !n2.isUp()) continue;
                if (indegree.containsKey(n2)) {
                    indegree.put(n2, (Integer)indegree.get(n2) + 1);
                    continue;
                }
                indegree.put(n2, 1);
            }
        }
        IncrementalFreq stats = new IncrementalFreq();
        for (Node n : indegree.keySet()) {
            stats.add(((Integer)indegree.get(n)).intValue());
        }
        this.output(stats);
        this.stopObservation();
        return false;
    }
}

