/*
 * Decompiled with CFR 0.152.
 */
package peernet.config;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

class ClassFinder {
    private static Map<String, String> map = new TreeMap<String, String>();

    ClassFinder() {
    }

    public static String getShortName(String className) {
        int index = className.lastIndexOf(46);
        if (index < 0) {
            return className;
        }
        return className.substring(index + 1);
    }

    public static String getQualifiedName(String name) {
        return map.get(name);
    }

    private static void findClasses(Map<String, String> map) throws IOException {
        String classPath = System.getProperty("java.class.path");
        String separator = System.getProperty("path.separator");
        String filesep = System.getProperty("file.separator");
        StringTokenizer path = new StringTokenizer(classPath, separator);
        while (path.hasMoreTokens()) {
            Object pathElement = path.nextToken();
            File pathFile = new File((String)pathElement);
            if (pathFile.isDirectory()) {
                if (!((String)pathElement).endsWith(filesep)) {
                    pathElement = (String)pathElement + filesep;
                    pathFile = new File((String)pathElement);
                }
                ClassFinder.findClassInPathDir(map, (String)pathElement, pathFile);
                continue;
            }
            if (!pathFile.exists()) continue;
            ClassFinder.findClassInJar(map, pathFile);
        }
    }

    private static void findClassInJar(Map<String, String> map, File pathFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(pathFile);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String entry = entries.nextElement().toString();
                if (!entry.endsWith(".class")) continue;
                String className = ClassFinder.classname(entry, "/");
                String shortName = ClassFinder.getShortName(className);
                if (map.containsKey(shortName)) {
                    map.put(shortName, map.get(shortName) + "," + className);
                    continue;
                }
                map.put(shortName, className);
            }
        }
    }

    private static void findClassInPathDir(Map<String, String> map, String pathElement, File pathFile) throws IOException {
        String[] list = pathFile.list();
        String filesep = System.getProperty("file.separator");
        for (int i = 0; i < list.length; ++i) {
            File file = new File(pathFile, list[i]);
            if (file.isDirectory()) {
                ClassFinder.findClassInPathDir(map, pathElement, file);
                continue;
            }
            if (!file.exists() || file.length() == 0L || !list[i].endsWith(".class")) continue;
            String classFile = file.toString().substring(pathElement.length());
            String className = ClassFinder.classname(classFile, filesep);
            String shortName = ClassFinder.getShortName(className);
            if (map.containsKey(shortName)) {
                map.put(shortName, map.get(shortName) + "," + className);
                continue;
            }
            map.put(shortName, className);
        }
    }

    private static String classname(String classFile, String filesep) {
        return classFile.replace(filesep, ".").substring(0, classFile.length() - ".class".length());
    }

    public static void main(String[] argv) {
        for (String key : map.keySet()) {
            String name = map.get(key);
            System.out.println(key + " --> " + name);
        }
    }

    static {
        try {
            ClassFinder.findClasses(map);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

