/*
 * Decompiled with CFR 0.152.
 */
package peernet.config;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class ConfigProperties
extends Properties {
    private static final long serialVersionUID = 1L;

    public ConfigProperties() {
    }

    public ConfigProperties(String[] pars, String resource) {
        try {
            if (resource != null) {
                this.loadSystemResource(resource);
                System.err.println("ConfigProperties: System resource " + resource + " loaded.");
            }
        }
        catch (Exception e) {
            System.err.println("ConfigProperties: " + String.valueOf(e));
        }
        if (pars == null || pars.length == 0) {
            return;
        }
        try {
            this.load(pars[0]);
            System.err.println("ConfigProperties: File " + pars[0] + " loaded.");
            pars[0] = "";
        }
        catch (IOException e) {
            System.err.println("ConfigProperties: Failed loading '" + pars[0] + "' as a file, interpreting it as a property.");
        }
        catch (Exception e) {
            System.err.println("ConfigProperties: " + String.valueOf(e));
        }
        if (pars.length == 1 && pars[0].length() == 0) {
            return;
        }
        try {
            this.loadCommandLineDefs(pars);
            System.err.println("ConfigProperties: Command line defs loaded.");
        }
        catch (Exception e) {
            System.err.println("ConfigProperties: " + String.valueOf(e));
        }
    }

    public ConfigProperties(String fileName) throws IOException {
        this.load(fileName);
    }

    public ConfigProperties(Properties props) {
        super(props);
    }

    public ConfigProperties(String[] pars) {
        this(pars, null);
    }

    public void load(String fileName) throws IOException {
        FileInputStream fis = new FileInputStream(fileName);
        this.load(fis);
        fis.close();
    }

    public void loadSystemResource(String n) throws IOException {
        ClassLoader cl = this.getClass().getClassLoader();
        this.load(cl.getResourceAsStream(n));
    }

    public void loadCommandLineDefs(String[] cl) throws IOException {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < cl.length; ++i) {
            sb.append(cl[i]).append("\n");
        }
        this.load(new ByteArrayInputStream(sb.toString().getBytes()));
    }
}

