/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import peernet.config.Configuration;
import peernet.core.Engine;
import peernet.util.ExtendedRandom;

public class CommonState {
    private static long time = 0L;
    private static long endTime = -1L;
    private static long zeroTime = -1L;
    private static String experienceName;
    public static ExtendedRandom r;
    public static final String PAR_RANDOM = "random";
    public static final String PAR_SEED = "random.seed";

    protected CommonState() {
    }

    public static long getTime() {
        Engine.Type t = Engine.getType();
        if (t == Engine.Type.SIM || t == Engine.Type.SIM_CUSTOM) {
            return time;
        }
        if (zeroTime == -1L) {
            return 0L;
        }
        return System.currentTimeMillis() - zeroTime;
    }

    static void timeStartsNow() {
        if (zeroTime != -1L) {
            throw new IllegalStateException("Cannot reset time to zero for a second time");
        }
        zeroTime = System.currentTimeMillis();
    }

    public static void setTime(long t) {
        time = t;
    }

    public static long getEndTime() {
        return endTime;
    }

    public static void setEndTime(long t) {
        if (endTime >= 0L) {
            throw new RuntimeException("You can set endtime only once");
        }
        if (t < 0L) {
            throw new RuntimeException("No negative values are allowed");
        }
        endTime = t;
    }

    public static void initializeRandom(long seed) {
        if (r == null) {
            r = (ExtendedRandom)Configuration.getInstance(PAR_RANDOM, new ExtendedRandom(seed));
        }
        r.setSeed(seed);
    }

    public static long getPendingEvents() {
        return Engine.instance().pendingEvents();
    }

    public static String getExperienceName() {
        return experienceName;
    }

    public static void setExperienceName(String experienceName) {
        CommonState.experienceName = experienceName;
    }

    static {
        r = null;
        long seed = Configuration.getLong(PAR_SEED, System.currentTimeMillis());
        CommonState.initializeRandom(seed);
    }
}

