/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.util.Arrays;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.EngineNet;
import peernet.core.EngineSim;
import peernet.core.Network;
import peernet.core.Node;
import peernet.core.Schedule;
import peernet.dynamics.NodeInitializer;
import peernet.transport.Address;

public abstract class Engine {
    private static final String PREFIX = "engine";
    private static final String PAR_DURATION = "duration";
    private static final String PAR_LOGTIME = "logtime";
    private static final String PAR_RBITS = "timebits";
    private static final String PAR_INIT = "init";
    private static final String PAR_CONTROL = "control";
    private static final String PAR_PROTOCOL = "protocol";
    private static final String PAR_SCHEDULE = "schedule";
    private static final String PAR_MODE = "mode";
    private static final String PAR_ENGINE_SIMULATION_VALUE = "sim";
    private static final String PAR_ENGINE_EMULATION_VALUE = "emu";
    private static final String PAR_ENGINE_NETWORK_VALUE = "net";
    private static final String PAR_ENGINE_COORDINATOR_VALUE = "coordinator";
    private static final String PAR_ENGINE_SIMULATION_CUSTOM_VALUE = "simcustom";
    private static final String PAR_CUSTOM_SIM_ENGINE_CLASS = "simengine";
    protected static long endtime;
    protected static long logtime;
    protected static int rbits;
    protected static Control[] controls;
    protected static Schedule[] controlSchedules;
    protected static Schedule[][] protocolSchedules;
    protected static long nextlog;
    private static Engine instance;
    private static final Type type;
    private static final AddressType addressType;
    private static final String engineName;

    public static Type getType() {
        return type;
    }

    public AddressType getAddressType() {
        return addressType;
    }

    private void runInitializers() {
        Object[] inits = Configuration.getInstanceArray(PAR_INIT);
        String[] names = Configuration.getNames(PAR_INIT);
        for (int i = 0; i < inits.length; ++i) {
            System.err.println("- Running initializer " + names[i] + ": " + String.valueOf(inits[i].getClass()));
            ((Control)inits[i]).execute();
        }
    }

    private void scheduleControls() {
        int i;
        String[] names = Configuration.getNames(PAR_CONTROL);
        controls = new Control[names.length];
        controlSchedules = new Schedule[names.length];
        for (i = 0; i < names.length; ++i) {
            Engine.controls[i] = (Control)Configuration.getInstance(names[i]);
            Engine.controlSchedules[i] = new Schedule(names[i]);
        }
        System.err.println("Engine: loaded controls " + String.valueOf(Arrays.asList(names)));
        for (i = 0; i < controls.length; ++i) {
            if (i > 127) {
                throw new IllegalArgumentException("Too many control objects");
            }
            long delay = controlSchedules[i].initialDelay();
            if (delay < 0L) continue;
            this.addEventIn(delay, null, null, i, null);
        }
    }

    private void scheduleProtocols(Node node) {
        int pid = 0;
        Schedule[][] scheduleArray = protocolSchedules;
        int n = scheduleArray.length;
        for (int i = 0; i < n; ++i) {
            Schedule[] schedList;
            for (Schedule sched : schedList = scheduleArray[i]) {
                long delay = sched.initialDelay();
                if (delay < 0L) continue;
                this.addEventIn(delay, null, node, pid, sched);
            }
            ++pid;
        }
    }

    private void scheduleProtocols() {
        int i;
        String[] protocolNames = Configuration.getNames(PAR_PROTOCOL);
        protocolSchedules = new Schedule[protocolNames.length][];
        for (i = 0; i < protocolNames.length; ++i) {
            String[] scheduleNames = Configuration.getNames(protocolNames[i] + ".schedule");
            Engine.protocolSchedules[i] = new Schedule[scheduleNames.length + 1];
            Engine.protocolSchedules[i][0] = new Schedule(protocolNames[i]);
            Engine.protocolSchedules[i][0].schedId = 0;
            for (int j = 0; j < scheduleNames.length; ++j) {
                String strSchedId = Configuration.suffix(scheduleNames[j]);
                if (!strSchedId.matches("^[0-9]+$")) {
                    throw new IllegalParameterException(scheduleNames[j], "Schedule identifiers have to be numeric. E.g., try " + protocolNames[i] + ".schedule.1");
                }
                int schedId = Integer.valueOf(strSchedId);
                if (schedId <= 0) {
                    throw new IllegalParameterException(scheduleNames[j], "Schedule identifiers have to be greater than zero. E.g., try " + protocolNames[i] + ".schedule.1");
                }
                Engine.protocolSchedules[i][j + 1] = new Schedule(scheduleNames[j]);
                Engine.protocolSchedules[i][j + 1].schedId = schedId;
            }
        }
        for (i = 0; i < Network.size(); ++i) {
            Node node = Network.get(i);
            this.scheduleProtocols(node);
        }
    }

    protected abstract void createHeaps();

    protected void addEventIn(long delay, Address src, Node node, int pid, Object event) {
        if (delay < 0L) {
            System.err.println("Event with negative delay: " + delay);
        }
        long nextTime = CommonState.getTime() + delay;
        this.addEventAt(nextTime, src, node, pid, event);
    }

    protected abstract void addEventAt(long var1, Address var3, Node var4, int var5, Object var6);

    public abstract long pendingEvents();

    public abstract void blockingInitializerStart();

    public abstract void blockingInitializerDone();

    public void startExperiment() {
        System.err.println("Engine: starting experiment in " + String.valueOf((Object)Engine.getType()) + " mode");
        rbits = Configuration.getInt("engine.timebits", 8);
        if (rbits < 8 || rbits >= 64) {
            throw new IllegalParameterException("engine.timebits", "This parameter should be >= 8 or < 64");
        }
        endtime = Configuration.getLong("engine.duration", Long.MAX_VALUE);
        CommonState.setEndTime(endtime);
        logtime = Configuration.getLong("engine.logtime", Long.MAX_VALUE);
        nextlog = 0L;
        System.err.println("Engine: resetting");
        Network.reset();
        this.createHeaps();
        this.runInitializers();
        this.scheduleControls();
        this.scheduleProtocols();
    }

    public static Engine instance() {
        if (instance == null) {
            switch (Engine.getType().ordinal()) {
                case 0: {
                    instance = new EngineSim();
                    break;
                }
                case 1: {
                    instance = new EngineNet();
                    break;
                }
                case 2: {
                    instance = new EngineNet();
                    break;
                }
                case 4: {
                    try {
                        Class<?> c = Class.forName(engineName);
                        instance = (Engine)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        break;
                    }
                    catch (Exception e) {
                        throw new IllegalParameterException("engine.simengine", engineName);
                    }
                }
                default: {
                    throw new IllegalParameterException("engine.mode", Configuration.getString("engine.mode"));
                }
            }
        }
        return instance;
    }

    public Node addNode(NodeInitializer[] inits) {
        Node n = Network.addNode();
        for (int i = 0; i < inits.length; ++i) {
            inits[i].initialize(n);
        }
        this.scheduleProtocols(n);
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static {
        controls = null;
        controlSchedules = null;
        protocolSchedules = null;
        nextlog = 0L;
        instance = null;
        String typeStr = Configuration.getString("engine.mode", "");
        if (typeStr.equals(PAR_ENGINE_SIMULATION_VALUE)) {
            type = Type.SIM;
            addressType = AddressType.SIM;
            engineName = null;
            return;
        } else if (typeStr.equals(PAR_ENGINE_EMULATION_VALUE)) {
            type = Type.EMU;
            addressType = AddressType.SIM;
            engineName = null;
            return;
        } else if (typeStr.equals(PAR_ENGINE_NETWORK_VALUE)) {
            type = Type.NET;
            addressType = AddressType.NET;
            engineName = null;
            return;
        } else if (typeStr.equals(PAR_ENGINE_COORDINATOR_VALUE)) {
            type = Type.COORDINATOR;
            addressType = null;
            engineName = null;
            return;
        } else {
            if (!typeStr.equals(PAR_ENGINE_SIMULATION_CUSTOM_VALUE)) throw new IllegalParameterException("engine.mode", "Possible types: sim, emu, net, coordinator, simcustom");
            if (!Configuration.contains("engine.simengine")) throw new IllegalParameterException("engine.mode", "Value simcustom requires specification of parameter: engine.simengine");
            type = Type.SIM_CUSTOM;
            addressType = AddressType.SIM;
            engineName = Configuration.getString("engine.simengine");
        }
    }

    public static enum Type {
        SIM,
        EMU,
        NET,
        COORDINATOR,
        SIM_CUSTOM;

    }

    public static enum AddressType {
        SIM,
        NET;

    }
}

