/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Node;

public class Network {
    private static final String PAR_NODE = "network.node";
    private static final String PAR_MAXSIZE = "network.maxSize";
    private static final String PAR_SIZE = "network.size";
    private static Node[] nodes = null;
    private static int len;
    private static Node prototype;
    private static Map<Long, Node> nodesByID;

    public static void reset() {
        prototype = null;
        nodes = null;
        len = Configuration.getInt(PAR_SIZE);
        int maxlen = Configuration.getInt(PAR_MAXSIZE, len);
        if (maxlen < len) {
            throw new IllegalArgumentException("network.maxSize is less than network.size");
        }
        nodes = new Node[maxlen];
        nodesByID = new HashMap<Long, Node>(maxlen);
        if (!Configuration.contains(PAR_NODE)) {
            System.err.println("Network: no node defined, using GeneralNode");
            prototype = new Node("");
        } else {
            prototype = (Node)Configuration.getInstance(PAR_NODE);
        }
        prototype.setIndex(-1);
        for (int i = 0; i < len; ++i) {
            Network.nodes[i] = (Node)prototype.clone();
            nodes[i].setIndex(i);
            nodesByID.put(nodes[i].getID(), nodes[i]);
        }
    }

    private Network() {
    }

    public static int size() {
        return len;
    }

    private static void setCapacity(int newSize) {
        if (nodes == null || newSize != nodes.length) {
            Node[] newnodes = new Node[newSize];
            int l = Math.min(nodes.length, newSize);
            System.arraycopy(nodes, 0, newnodes, 0, l);
            nodes = newnodes;
            if (len > newSize) {
                len = newSize;
            }
        }
    }

    public static int getCapacity() {
        return nodes.length;
    }

    static Node addNode() {
        Node n;
        if (len == nodes.length) {
            Network.setCapacity(3 * nodes.length / 2 + 1);
        }
        Network.nodes[Network.len] = n = (Node)prototype.clone();
        n.setIndex(len);
        nodesByID.put(n.getID(), n);
        ++len;
        return n;
    }

    public static Node get(int index) {
        return nodes[index];
    }

    public static Node getByID(long ID) {
        return nodesByID.get(ID);
    }

    public static Node removeLast() {
        Node n = nodes[len - 1];
        Network.nodes[Network.len - 1] = null;
        nodesByID.remove(n.getID());
        --len;
        n.setFailState(1);
        return n;
    }

    public static Node remove(Node n) {
        return Network.remove(n.getIndex());
    }

    public static Node remove(int i) {
        if (i < 0 || i >= len) {
            throw new IndexOutOfBoundsException("" + i);
        }
        Network.swap(i, len - 1);
        return Network.removeLast();
    }

    private static void swap(int i, int j) {
        Node n = nodes[i];
        Network.nodes[i] = nodes[j];
        Network.nodes[j] = n;
        nodes[j].setIndex(j);
        nodes[i].setIndex(i);
    }

    public static void shuffle() {
        for (int i = len; i > 1; --i) {
            Network.swap(i - 1, CommonState.r.nextInt(i));
        }
    }

    public static void sort(Comparator<? super Node> c) {
        Arrays.sort(nodes, 0, len, c);
        for (int i = 0; i < len; ++i) {
            nodes[i].setIndex(i);
        }
    }

    static {
        prototype = null;
    }
}

