/*
 * Decompiled with CFR 0.152.
 */
package peernet.core;

import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;

public class Schedule {
    public static final String PAR_STEP = "step";
    public static final String PAR_AT = "at";
    public static final String PAR_FROM = "from";
    public static final String PAR_UNTIL = "until";
    private static final String PAR_FINAL = "final";
    private static final String PAR_RANDOMSTART = "randstart";
    public int schedId;
    public long step;
    public long from;
    public long until;
    public boolean fin;
    public boolean randomStart;
    protected long next;

    public Schedule(String prefix) {
        this.fin = Configuration.contains(prefix + ".final");
        if (Configuration.contains(prefix + ".at")) {
            long at;
            if (Configuration.contains(prefix + ".from") || Configuration.contains(prefix + ".until") || Configuration.contains(prefix + ".step")) {
                throw new IllegalParameterException(prefix, "Cannot use \"at\" and \"from\"/\"until\"/\"step\" together");
            }
            this.from = at = Configuration.getLong(prefix + ".at");
            this.until = at;
            this.step = 1L;
        } else {
            this.from = Configuration.getLong(prefix + ".from", 0L);
            this.until = Configuration.getLong(prefix + ".until", Long.MAX_VALUE);
            this.step = Configuration.getLong(prefix + ".step", -1L);
            this.randomStart = Configuration.contains(prefix + ".randstart");
            if (this.step == -1L) {
                this.step = -1L;
                this.until = -1L;
                this.from = -1L;
                if (Configuration.contains(prefix + ".from") || Configuration.contains(prefix + ".until")) {
                    System.err.println("Warning: Control " + prefix + " defines \"from\"/\"until\" but not \"step\"");
                }
                if (!this.fin) {
                    System.err.println("Warning: Control " + prefix + " will not execute at all!");
                }
            }
        }
        this.next = this.from;
    }

    public boolean active(long time) {
        if (time < this.from || time > this.until) {
            return false;
        }
        return (time - this.from) % this.step == 0L;
    }

    public long getNext() {
        long ret = this.next;
        this.next += this.step;
        if (this.next >= this.until) {
            ret = -1L;
        }
        return ret;
    }

    long initialDelay() {
        if (this.randomStart) {
            return this.from + CommonState.r.nextLong(this.step);
        }
        return this.from;
    }

    public long nextDelay(long time) {
        if (time + this.step <= this.until) {
            return this.step;
        }
        return -1L;
    }
}

