/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.core.Engine;
import peernet.core.Network;
import peernet.dynamics.NodeInitializer;

public class OscillatingNetwork
implements Control {
    private static final String PAR_INIT = "init";
    private static final String PAR_MAX = "maxsize";
    private static final String PAR_MIN = "minsize";
    private static final String PAR_PERIOD = "period";
    private final int period;
    private final int minsize;
    private final int maxsize;
    private final NodeInitializer[] inits;

    public OscillatingNetwork(String prefix) {
        this.period = Configuration.getInt(prefix + ".period");
        this.maxsize = Configuration.getInt(prefix + ".maxsize", Network.getCapacity());
        this.minsize = Configuration.getInt(prefix + ".minsize", 0);
        Object[] tmp = Configuration.getInstanceArray(prefix + ".init");
        this.inits = new NodeInitializer[tmp.length];
        for (int i = 0; i < tmp.length; ++i) {
            this.inits[i] = (NodeInitializer)tmp[i];
        }
    }

    protected void add(int k) {
        while (k > 0) {
            Engine.instance().addNode(this.inits);
            --k;
        }
    }

    protected void remove(int n) {
        for (int i = 0; i < n; ++i) {
            Network.remove(CommonState.r.nextInt(Network.size()));
        }
    }

    @Override
    public boolean execute() {
        long time = CommonState.getTime();
        int amplitude = (this.maxsize - this.minsize) / 2;
        int newsize = (this.maxsize + this.minsize) / 2 + (int)(Math.sin((double)time / (double)this.period * Math.PI) * (double)amplitude);
        int diff = newsize - Network.size();
        if (diff < 0) {
            this.remove(-diff);
        } else {
            this.add(diff);
        }
        return false;
    }
}

