/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import peernet.config.Configuration;
import peernet.dynamics.WireControl;
import peernet.graph.Graph;
import peernet.transport.OverlayGraph;

public abstract class WireGraph
implements WireControl {
    private static final String PAR_PROT = "protocol";
    private static final String PAR_UNDIR = "undir";
    private static final String PAR_UNDIR_ALT = "undirected";
    private final int pid;
    public final boolean undir;
    private Graph g = null;

    protected WireGraph(String prefix) {
        this.pid = Configuration.getPid(prefix + ".protocol", -10);
        this.undir = Configuration.contains(prefix + ".undir") | Configuration.contains(prefix + ".undirected");
    }

    @Override
    public final boolean execute() {
        if (this.g == null && this.pid == -10) {
            throw new RuntimeException("Neither a protocol, nor a graph is specified.");
        }
        Graph gr = this.g == null ? new OverlayGraph(this.pid, !this.undir) : this.g;
        if (gr.size() == 0) {
            return false;
        }
        this.wire(gr);
        return false;
    }

    @Override
    public final void setGraph(Graph graph) {
        this.g = graph;
    }

    public abstract void wire(Graph var1);
}

