/*
 * Decompiled with CFR 0.152.
 */
package peernet.dynamics;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.dynamics.WireGraph;
import peernet.graph.Graph;

public class WireScaleFreeDM
extends WireGraph {
    private static final String PAR_EDGES = "k";
    private final int k;

    public WireScaleFreeDM(String prefix) {
        super(prefix);
        this.k = Configuration.getInt(prefix + ".k");
    }

    @Override
    public void wire(Graph g) {
        int i;
        int nodes = g.size();
        int[] links = new int[4 * this.k * nodes];
        int clique = this.k > 3 ? this.k : 3;
        int len = 0;
        for (i = 0; i < clique; ++i) {
            for (int j = 0; j < clique; ++j) {
                if (i == j) continue;
                g.setEdge(i, j);
                g.setEdge(j, i);
                links[len * 2] = i;
                links[len * 2 + 1] = j;
                ++len;
            }
        }
        for (i = clique; i < nodes; ++i) {
            for (int l = 0; l < this.k; ++l) {
                int edge = CommonState.r.nextInt(len);
                int m = links[edge * 2];
                int j = links[edge * 2 + 1];
                g.setEdge(i, m);
                g.setEdge(m, i);
                g.setEdge(j, m);
                g.setEdge(m, j);
                links[len * 2] = i;
                links[len * 2 + 1] = m;
                links[++len * 2] = j;
                links[len * 2 + 1] = m;
                ++len;
            }
        }
    }
}

