/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import peernet.graph.Graph;

public class BitMatrixGraph
implements Graph {
    private final List<BitSet> sets;
    private final boolean directed;

    public BitMatrixGraph(int n) {
        this(n, true);
    }

    public BitMatrixGraph(int n, boolean directed) {
        this.sets = new ArrayList<BitSet>(n);
        for (int i = 0; i < n; ++i) {
            this.sets.add(new BitSet());
        }
        this.directed = directed;
    }

    @Override
    public boolean isEdge(int i, int j) {
        return this.sets.get(i).get(j);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        HashSet<Integer> result = new HashSet<Integer>();
        BitSet neighb = this.sets.get(i);
        int max = this.size();
        for (int j = 0; j < max; ++j) {
            if (!neighb.get(j)) continue;
            result.add(j);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getNode(int i) {
        return null;
    }

    @Override
    public Object getEdge(int i, int j) {
        return null;
    }

    @Override
    public int size() {
        return this.sets.size();
    }

    @Override
    public boolean directed() {
        return this.directed;
    }

    @Override
    public boolean setEdge(int i, int j) {
        if (i > this.size() || j > this.size() || i < 0 || j < 0) {
            throw new IndexOutOfBoundsException();
        }
        BitSet neighb = this.sets.get(i);
        boolean old = neighb.get(j);
        neighb.set(j);
        if (!old && !this.directed) {
            neighb = this.sets.get(j);
            neighb.set(i);
        }
        return !old;
    }

    @Override
    public boolean clearEdge(int i, int j) {
        if (i > this.size() || j > this.size() || i < 0 || j < 0) {
            throw new IndexOutOfBoundsException();
        }
        BitSet neighb = this.sets.get(i);
        boolean old = neighb.get(j);
        neighb.clear(j);
        if (old && !this.directed) {
            neighb = this.sets.get(i);
            neighb.clear(j);
        }
        return old;
    }

    @Override
    public int degree(int i) {
        BitSet neighb = this.sets.get(i);
        return neighb.cardinality();
    }
}

