/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import peernet.graph.Graph;

public class ConstUndirGraph
implements Graph {
    protected final Graph g;
    protected final List<Integer>[] in;

    public ConstUndirGraph(Graph g) {
        this.g = g;
        this.in = !g.directed() ? null : new List[g.size()];
        this.initGraph();
    }

    protected void initGraph() {
        int i;
        int max = this.g.size();
        for (i = 0; i < max; ++i) {
            this.in[i] = new ArrayList<Integer>();
        }
        for (i = 0; i < max; ++i) {
            for (Integer j : this.g.getNeighbours(i)) {
                if (j < 0 || this.g.isEdge(j, i)) continue;
                this.in[j].add(i);
            }
        }
    }

    @Override
    public boolean isEdge(int i, int j) {
        return this.g.isEdge(i, j) || this.g.isEdge(j, i);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        result.addAll(this.g.getNeighbours(i));
        if (this.in != null) {
            result.addAll(this.in[i]);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getNode(int i) {
        return this.g.getNode(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        if (this.g.isEdge(i, j)) {
            return this.g.getEdge(i, j);
        }
        if (this.g.isEdge(j, i)) {
            return this.g.getEdge(j, i);
        }
        return null;
    }

    @Override
    public int size() {
        return this.g.size();
    }

    @Override
    public boolean directed() {
        return false;
    }

    @Override
    public boolean setEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean clearEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree(int i) {
        return this.g.degree(i) + (this.in == null ? 0 : this.in[i].size());
    }
}

