/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.ArrayList;
import java.util.BitSet;
import peernet.graph.ConstUndirGraph;
import peernet.graph.Graph;

public class GraphAdaptor
extends ConstUndirGraph {
    private BitSet[] edgeMatrix;
    private Dir dir;

    public GraphAdaptor(Graph graph) {
        super(graph);
    }

    @Override
    protected void initGraph() {
        int i;
        int max = this.g.size();
        this.edgeMatrix = new BitSet[max];
        for (i = 0; i < max; ++i) {
            this.in[i] = new ArrayList();
            this.edgeMatrix[i] = new BitSet(this.dir == Dir.BIDIRECTIONAL ? i : max);
        }
        for (i = 0; i < max; ++i) {
            for (Integer out : this.g.getNeighbours(i)) {
                int j = out;
                this.in[j].add(i);
                this.addEdge(i, j);
            }
        }
    }

    private void addEdge(int i, int j) {
    }

    @Override
    public boolean isEdge(int i, int j) {
        if (i < j) {
            int ii = i;
            i = j;
            j = ii;
        }
        return this.edgeMatrix[i].get(j);
    }

    private static enum Dir {
        NORMAL,
        REVERSE,
        BIDIRECTIONAL;

    }
}

