/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.Stack;
import peernet.graph.Graph;

public class GraphAlgorithms {
    public int[] root = null;
    private Stack<Integer> stack = new Stack();
    private int counter = 0;
    private Graph g = null;
    public static final int WHITE = 0;
    public static final int GREY = 1;
    public static final int BLACK = 2;
    public int[] color = null;
    public Set<Integer> cluster = null;
    public int[] d = null;

    private void dfs(int from) {
        this.color[from] = 1;
        for (int j : this.g.getNeighbours(from)) {
            if (this.color[j] == 0) {
                this.dfs(j);
                continue;
            }
            if (this.color[j] >= 0) continue;
            this.cluster.add(this.color[j]);
        }
        this.color[from] = 2;
    }

    private void bfs(int from) {
        LinkedList<Integer> q = new LinkedList<Integer>();
        q.add(from);
        q.add(0);
        if (this.d != null) {
            this.d[from] = 0;
        }
        this.color[from] = 1;
        while (!q.isEmpty()) {
            int u = (Integer)q.remove(0);
            int du = (Integer)q.remove(0);
            for (int j : this.g.getNeighbours(u)) {
                if (j < 0) continue;
                if (this.color[j] == 0) {
                    this.color[j] = 1;
                    q.add(j);
                    q.add(du + 1);
                    if (this.d == null) continue;
                    this.d[j] = du + 1;
                    continue;
                }
                if (this.color[j] >= 0) continue;
                this.cluster.add(this.color[j]);
            }
            this.color[u] = 2;
        }
    }

    private void tarjanVisit(int i) {
        ++this.counter;
        this.root[i] = i;
        this.stack.push(i);
        for (int j : this.g.getNeighbours(i)) {
            if (this.color[j] == 0) {
                this.tarjanVisit(j);
            }
            if (this.color[j] <= 0 || this.color[this.root[j]] >= this.color[this.root[i]]) continue;
            this.root[i] = this.root[j];
        }
        if (this.root[i] == i) {
            int j;
            do {
                j = this.stack.pop();
                this.color[j] = -this.color[j];
                this.root[j] = i;
            } while (j != i);
        }
    }

    public Map<Integer, Integer> weaklyConnectedClusters(Graph g) {
        int j;
        int i;
        this.g = g;
        if (this.cluster == null) {
            this.cluster = new HashSet<Integer>();
        }
        if (this.color == null || this.color.length < g.size()) {
            this.color = new int[g.size()];
        }
        int actCluster = 0;
        for (i = 0; i < g.size(); ++i) {
            this.color[i] = 0;
        }
        for (i = 0; i < g.size(); ++i) {
            if (this.color[i] != 0) continue;
            this.cluster.clear();
            this.bfs(i);
            --actCluster;
            for (j = 0; j < g.size(); ++j) {
                if (this.color[j] != 2 && !this.cluster.contains(this.color[j])) continue;
                this.color[j] = actCluster;
            }
        }
        Hashtable<Integer, Integer> ht = new Hashtable<Integer, Integer>();
        Integer one = 1;
        for (j = 0; j < g.size(); ++j) {
            Integer in = this.color[j];
            Integer num = ht.get(in);
            if (num == null) {
                ht.put(in, one);
                continue;
            }
            ht.put(in, num + 1);
        }
        return ht;
    }

    public void dist(Graph g, int i) {
        this.g = g;
        if (this.d == null || this.d.length < g.size()) {
            this.d = new int[g.size()];
        }
        if (this.color == null || this.color.length < g.size()) {
            this.color = new int[g.size()];
        }
        for (int j = 0; j < g.size(); ++j) {
            this.color[j] = 0;
            this.d[j] = -1;
        }
        this.bfs(i);
    }

    public static double clustering(Graph g, int i) {
        if (g.directed()) {
            throw new IllegalArgumentException("graph is directed");
        }
        Object[] n = g.getNeighbours(i).toArray();
        if (n.length == 1) {
            return 1.0;
        }
        int edges = 0;
        for (int j = 0; j < n.length; ++j) {
            for (int k = j + 1; k < n.length; ++k) {
                if (!g.isEdge((Integer)n[j], (Integer)n[k])) continue;
                ++edges;
            }
        }
        return (double)edges * 2.0 / (double)n.length / (double)(n.length - 1);
    }

    public static void multicast(Graph g, int[] b, Random r) {
        int k;
        int[] c1 = new int[g.size()];
        int[] c2 = new int[g.size()];
        for (int i = 0; i < c1.length; ++i) {
            c1[i] = 0;
            c2[i] = 0;
        }
        c1[0] = 2;
        c2[0] = 2;
        Collection<Integer> neighbours = null;
        int black = 1;
        for (k = 0; k < b.length || black < g.size(); ++k) {
            for (int i = 0; i < c2.length; ++i) {
                neighbours = g.getNeighbours(i);
                Iterator<Integer> it = neighbours.iterator();
                for (int j = r.nextInt(neighbours.size()); j > 0; --j) {
                    it.next();
                }
                int randn = it.next();
                if (c1[i] == 2) {
                    if (c2[randn] == 0) {
                        ++black;
                    }
                    c2[randn] = 2;
                    continue;
                }
                if (c1[randn] != 2) continue;
                if (c2[i] == 0) {
                    ++black;
                }
                c2[i] = 2;
            }
            System.arraycopy(c2, 0, c1, 0, c1.length);
            b[k] = black;
        }
        while (k < b.length) {
            b[k] = g.size();
            ++k;
        }
    }

    public void flooding(Graph g, int[] b, int k) {
        int i;
        this.dist(g, k);
        for (i = 0; i < b.length; ++i) {
            b[i] = 0;
        }
        for (i = 0; i < this.d.length; ++i) {
            if (this.d[i] < 0 || this.d[i] >= b.length) continue;
            int n = this.d[i];
            b[n] = b[n] + 1;
        }
    }

    public Map<Integer, Integer> tarjan(Graph g) {
        int i;
        this.g = g;
        this.stack.clear();
        if (this.root == null || this.root.length < g.size()) {
            this.root = new int[g.size()];
        }
        if (this.color == null || this.color.length < g.size()) {
            this.color = new int[g.size()];
        }
        for (i = 0; i < g.size(); ++i) {
            this.color[i] = 0;
        }
        this.counter = 1;
        for (i = 0; i < g.size(); ++i) {
            if (this.color[i] != 0) continue;
            this.tarjanVisit(i);
        }
        for (i = 0; i < g.size(); ++i) {
            this.color[i] = 0;
        }
        for (i = 0; i < g.size(); ++i) {
            int n = this.root[i];
            this.color[n] = this.color[n] + 1;
        }
        Hashtable<Integer, Integer> ht = new Hashtable<Integer, Integer>();
        for (int j = 0; j < g.size(); ++j) {
            if (this.color[j] <= 0) continue;
            ht.put(j, this.color[j]);
        }
        return ht;
    }
}

