/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.BitSet;
import java.util.Iterator;
import peernet.graph.Graph;
import peernet.graph.NeighborListGraph;

public class GraphIO {
    private GraphIO() {
    }

    public static void writeEdgeList(Graph g, PrintStream out) {
        for (int i = 0; i < g.size(); ++i) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.println(i + " " + String.valueOf(it.next()));
            }
        }
    }

    public static void writeNeighborList(Graph g, PrintStream out) {
        out.println("# " + g.size());
        for (int i = 0; i < g.size(); ++i) {
            out.print(i + " ");
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.print(String.valueOf(it.next()) + " ");
            }
            out.println();
        }
    }

    public static void writeGML(Graph g, PrintStream out) {
        int i;
        out.println("graph [ directed " + (g.directed() ? "1" : "0"));
        for (i = 0; i < g.size(); ++i) {
            out.println("node [ id " + i + " ]");
        }
        for (i = 0; i < g.size(); ++i) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.println("edge [ source " + i + " target " + String.valueOf(it.next()) + " ]");
            }
        }
        out.println("]");
    }

    public static void writeNetmeter(Graph g, PrintStream out) {
        int i;
        out.println("*Vertices " + g.size());
        for (i = 0; i < g.size(); ++i) {
            out.println(i + 1 + " \"" + (i + 1) + "\"");
        }
        out.println("*Arcs");
        for (i = 0; i < g.size(); ++i) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.println(i + 1 + " " + (it.next() + 1) + " 1");
            }
        }
        out.println("*Edges");
    }

    public static void writeUCINET_DL(Graph g, PrintStream out) {
        out.println("DL\nN=" + g.size() + "\nFORMAT=NODELIST\nDATA:");
        for (int i = 0; i < g.size(); ++i) {
            out.print(" " + (i + 1));
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.print(" " + (it.next() + 1));
            }
            out.println();
        }
        out.println();
    }

    public static void writeUCINET_DLMatrix(Graph g, PrintStream out) {
        out.println("DL\nN=" + g.size() + "\nDATA:");
        for (int i = 0; i < g.size(); ++i) {
            BitSet bs = new BitSet(g.size());
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                bs.set(it.next());
            }
            for (int j = 0; j < g.size(); ++j) {
                out.print(bs.get(j) ? " 1" : " 0");
            }
            out.println();
        }
        out.println();
    }

    public static void writeChaco(Graph g, PrintStream out) {
        int i;
        if (g.directed()) {
            System.err.println("warning: you're saving a directed graph in Chaco format");
        }
        long edges = 0L;
        for (i = 0; i < g.size(); ++i) {
            edges += (long)g.getNeighbours(i).size();
        }
        out.println(g.size() + " " + edges / 2L);
        for (i = 0; i < g.size(); ++i) {
            Iterator<Integer> it = g.getNeighbours(i).iterator();
            while (it.hasNext()) {
                out.print(it.next() + 1 + " ");
            }
            out.println();
        }
        out.println();
    }

    public static Graph readNewscastGraph(String file, int direction) throws IOException {
        NeighborListGraph gr = new NeighborListGraph(direction != 2);
        FileInputStream fis = new FileInputStream(file);
        DataInputStream dis = new DataInputStream(fis);
        dis.readByte();
        dis.readByte();
        dis.readByte();
        int MODE = dis.readInt();
        if (MODE != 1) {
            dis.close();
            throw new IOException("Unknown mode " + MODE);
        }
        int CACHESIZE = dis.readInt();
        int GRAPHSIZE = dis.readInt();
        for (int i = 1; i <= GRAPHSIZE; ++i) {
            int iind = gr.addNode(i);
            for (int j = 0; j < CACHESIZE; ++j) {
                int a = dis.readInt();
                dis.readLong();
                int agentIndex = gr.addNode(a);
                if (direction == 0) {
                    gr.setEdge(iind, agentIndex);
                    continue;
                }
                gr.setEdge(agentIndex, iind);
            }
        }
        dis.close();
        return gr;
    }
}

