/*
 * Decompiled with CFR 0.152.
 */
package peernet.graph;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import peernet.graph.Graph;

public class PrefixSubGraph
implements Graph {
    private final Graph g;
    private int prefSize;

    public PrefixSubGraph(Graph g) {
        this.g = g;
        this.prefSize = g.size();
    }

    @Override
    public boolean isEdge(int i, int j) {
        if (i < 0 || i >= this.prefSize) {
            throw new IndexOutOfBoundsException();
        }
        if (j < 0 || j >= this.prefSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.g.isEdge(i, j);
    }

    @Override
    public Collection<Integer> getNeighbours(int i) {
        if (i < 0 || i >= this.prefSize) {
            throw new IndexOutOfBoundsException();
        }
        LinkedList<Integer> result = new LinkedList<Integer>();
        for (Integer j : this.g.getNeighbours(i)) {
            if (j >= this.prefSize) continue;
            result.add(j);
        }
        return Collections.unmodifiableCollection(result);
    }

    @Override
    public Object getNode(int i) {
        if (i < 0 || i >= this.prefSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.g.getNode(i);
    }

    @Override
    public Object getEdge(int i, int j) {
        if (this.isEdge(i, j)) {
            return this.g.getEdge(i, j);
        }
        return null;
    }

    @Override
    public int size() {
        return this.prefSize;
    }

    @Override
    public boolean directed() {
        return this.g.directed();
    }

    @Override
    public boolean setEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean clearEdge(int i, int j) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int degree(int i) {
        if (i < 0 || i >= this.prefSize) {
            throw new IndexOutOfBoundsException();
        }
        return this.g.degree(i);
    }

    public int setSize(int i) {
        int was = this.prefSize;
        if (i < 0) {
            i = 0;
        }
        if (i > this.g.size()) {
            i = this.g.size();
        }
        this.prefSize = i;
        return was;
    }
}

