/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Network;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;
import peernet.util.RandPermutation;

public class BallExpansion
extends GraphObserver {
    private static final String PAR_MAXD = "maxd";
    private static final String PAR_N = "n";
    private static final String PAR_STATS = "stats";
    private final int maxd;
    private final int n;
    private final boolean stats;
    private final int[] b;
    private final RandPermutation rp = new RandPermutation(CommonState.r);

    public BallExpansion(String name) {
        super(name);
        this.maxd = Configuration.getInt(name + ".maxd", Network.size());
        this.n = Configuration.getInt(name + ".n", 1000);
        this.stats = Configuration.contains(name + ".stats");
        this.b = new int[this.maxd];
    }

    @Override
    public boolean execute() {
        this.startObservation();
        this.updateGraph();
        this.rp.reset(this.g.size());
        if (this.stats) {
            IncrementalStats is = new IncrementalStats();
            for (int i = 0; i < this.n && i < this.g.size(); ++i) {
                this.ga.dist(this.g, this.rp.next());
                for (int j = 0; j < this.g.size(); ++j) {
                    if (this.ga.d[j] > 0) {
                        is.add(this.ga.d[j]);
                        continue;
                    }
                    if (this.ga.d[j] != -1) continue;
                    is.add(Double.POSITIVE_INFINITY);
                }
            }
            this.output(is);
        } else {
            for (int i = 0; i < this.n && i < this.g.size(); ++i) {
                this.ga.flooding(this.g, this.b, this.rp.next());
                int numReached = 0;
                for (int j = 0; j < this.b.length && this.b[j] > 0; ++j) {
                    numReached += this.b[j];
                }
                this.output(Network.size() + this.separator + numReached);
            }
        }
        this.stopObservation();
        return false;
    }
}

