/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;
import peernet.core.Network;
import peernet.core.Node;
import peernet.reports.GraphObserver_2;
import peernet.transport.OverlayGraph;
import peernet.util.IncrementalFreq;
import peernet.util.IncrementalStats;
import peernet.util.RandPermutation;

public class DegreeStats_2
extends GraphObserver_2 {
    private static final String PAR_N = "n";
    private static final String PAR_TRACE = "trace";
    private static final String PAR_METHOD = "method";
    private static final String PAR_TYPE = "linktype";
    private final int n;
    private final boolean trace;
    private Node[] traced = null;
    private final String method;
    private final String type;
    private final RandPermutation rp = new RandPermutation(CommonState.r);
    private int nextnode = 0;

    public DegreeStats_2(String name) {
        super(name);
        this.n = Configuration.getInt(name + ".n", -1);
        this.trace = Configuration.contains(name + ".trace");
        this.method = Configuration.getString(name + ".method", "stats");
        this.type = Configuration.getString(name + ".linktype", "live");
        if ((this.type.equals("all") || this.type.equals("dead")) && this.undir) {
            throw new IllegalParameterException(name + ".linktype", " Parameter " + name + ".undir must not be defined if " + name + ".linktype=" + this.type + ".");
        }
    }

    private int nextNodeId() {
        if (this.trace) {
            if (this.traced == null) {
                int nn = this.n < 0 ? Network.size() : this.n;
                this.traced = new Node[nn];
                for (int j = 0; j < nn; ++j) {
                    this.traced[j] = Network.get(j);
                }
            }
            return this.traced[this.nextnode++].getIndex();
        }
        return this.rp.next();
    }

    private int nextDegree() {
        int nodeid = this.nextNodeId();
        if (this.type.equals("live")) {
            return this.g.degree(nodeid);
        }
        if (this.type.equals("all")) {
            return ((OverlayGraph)this.g).fullDegree(nodeid);
        }
        if (this.type.equals("dead")) {
            return ((OverlayGraph)this.g).fullDegree(nodeid) - this.g.degree(nodeid);
        }
        throw new RuntimeException(this.name + ": invalid type");
    }

    @Override
    public boolean execute() {
        int nn;
        this.startObservation();
        this.updateGraph();
        if (!this.trace) {
            this.rp.reset(this.g.size());
        } else {
            this.nextnode = 0;
        }
        int n = nn = this.n < 0 ? Network.size() : this.n;
        if (this.method.equals("stats")) {
            IncrementalStats stats = new IncrementalStats();
            for (int i = 0; i < nn; ++i) {
                stats.add(this.nextDegree());
            }
            this.output(stats);
        } else if (this.method.equals("freq")) {
            IncrementalFreq stats = new IncrementalFreq();
            for (int i = 0; i < nn; ++i) {
                stats.add(this.nextDegree());
            }
            this.output(stats);
        } else if (this.method.equals("list")) {
            for (int i = 0; i < nn; ++i) {
                this.outputNoLine(this.nextDegree() + this.separator);
            }
            this.outputEndLine();
        }
        this.stopObservation();
        return false;
    }
}

