/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;
import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.core.Control;
import peernet.util.IncrementalFreq;
import peernet.util.IncrementalStats;

public abstract class FileObserver
implements Control {
    private static final String PAR_FILENAME = "filename";
    private static final String PAR_MULTIPLE_FILES = "multifile";
    private static final String PAR_TAG_TIME = "tagtime";
    private static final String PAR_SEPARATOR = "separator";
    private String filename;
    private boolean multifiles;
    private boolean tagtime;
    private PrintStream out;
    protected String separator;

    public FileObserver(String prefix) {
        this.filename = Configuration.getString(prefix + ".filename", null);
        if (this.filename == null) {
            this.out = System.out;
        } else {
            this.multifiles = Configuration.getBoolean(prefix + ".multifile", false);
        }
        this.tagtime = Configuration.getBoolean(prefix + ".tagtime", false);
        this.separator = Configuration.getString(prefix + ".separator", " ");
        if (!this.multifiles) {
            try {
                this.out = new PrintStream(new File(CommonState.getExperienceName() + "-" + this.filename + ".txt"));
            }
            catch (FileNotFoundException e) {
                this.out = System.out;
            }
        }
    }

    public void startObservation() {
        if (this.multifiles) {
            try {
                this.out = new PrintStream(new File(CommonState.getExperienceName() + "-" + this.filename + "-" + CommonState.getTime() + ".txt"));
            }
            catch (FileNotFoundException e) {
                this.out = System.out;
            }
        }
    }

    public void output(String s) {
        if (this.tagtime) {
            this.out.print(CommonState.getTime() + this.separator);
        }
        this.out.println(s);
    }

    public void output(IncrementalStats is) {
        if (this.tagtime) {
            this.out.print(CommonState.getTime() + this.separator);
        }
        this.out.println(is.toString(this.separator));
    }

    public void output(IncrementalFreq stats) {
        if (this.tagtime) {
            this.out.println(CommonState.getTime() + this.separator);
        }
        this.out.println(stats.toString(this.separator));
    }

    public void outputNoLine(String s) {
        this.out.print(s);
    }

    public void outputEndLine() {
        this.out.println();
    }

    public void stopObservation() {
        this.out.flush();
        if (this.multifiles) {
            this.out.close();
        }
    }
}

