/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.core.CommonState;
import peernet.graph.ConstUndirGraph;
import peernet.graph.FastUndirGraph;
import peernet.graph.Graph;
import peernet.graph.GraphAlgorithms;
import peernet.reports.FileObserver;
import peernet.transport.OverlayGraph;

public abstract class GraphObserver
extends FileObserver {
    private static final String PAR_PROT = "protocol";
    protected static final String PAR_UNDIR = "undir";
    private static final String PAR_UNDIR_ALT = "undirected";
    private static final String PAR_FAST = "graphobserver.fast";
    protected final String name;
    protected final int pid;
    protected final boolean undir;
    protected final GraphAlgorithms ga = new GraphAlgorithms();
    protected Graph g;
    private static int lastpid = -1;
    private static long time = -1L;
    private static Graph dirg;
    private static Graph undirg;
    private static boolean fast;
    private static boolean needUndir;

    protected GraphObserver(String name) {
        super(name);
        this.name = name;
        this.pid = Configuration.getPid(name + ".protocol");
        this.undir = Configuration.contains(name + ".undir") | Configuration.contains(name + ".undirected");
        fast = Configuration.contains(PAR_FAST);
        needUndir = needUndir || this.undir;
    }

    protected void updateGraph() {
        if (CommonState.getTime() != time || this.pid != lastpid) {
            lastpid = this.pid;
            time = CommonState.getTime();
            dirg = new OverlayGraph(this.pid);
            if (needUndir) {
                undirg = fast ? new FastUndirGraph(dirg) : new ConstUndirGraph(dirg);
            }
        }
        this.g = this.undir ? undirg : dirg;
    }

    static {
        needUndir = false;
    }
}

