/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.CommonState;
import peernet.graph.ConstUndirGraph;
import peernet.graph.FastUndirGraph;
import peernet.graph.Graph;
import peernet.graph.GraphAlgorithms;
import peernet.graph.ReverseGraph;
import peernet.reports.FileObserver;
import peernet.transport.OverlayGraph;

public abstract class GraphObserver_2
extends FileObserver {
    private static final String PAR_PROT = "protocol";
    protected static final String PAR_UNDIR = "undir";
    protected static final String PAR_REVERSE = "reverse";
    private static final String PAR_UNDIR_ALT = "undirected";
    protected final String name;
    protected final int pid;
    protected final boolean undir;
    protected final boolean reverse;
    protected final GraphAlgorithms ga = new GraphAlgorithms();
    protected Graph g;
    private static int lastpid = -1234;
    private static long time = -1234L;
    private static Graph dirg;
    private static Graph undirg;
    private static Graph reverseg;
    private static boolean fast;
    private static boolean needUndir;
    private static boolean needReverse;

    protected GraphObserver_2(String name) {
        super(name);
        this.name = name;
        this.pid = Configuration.getPid(name + ".protocol");
        this.undir = Configuration.contains(name + ".undir") | Configuration.contains(name + ".undirected");
        this.reverse = Configuration.contains(name + ".reverse");
        if (this.undir && this.reverse) {
            throw new IllegalParameterException(name + ".undir, " + name + ".reverse", "Parameters must not be defined together.");
        }
        needUndir = needUndir || this.undir;
        needReverse = needReverse || this.reverse;
    }

    protected void updateGraph() {
        if (CommonState.getTime() != time || this.pid != lastpid) {
            lastpid = this.pid;
            time = CommonState.getTime();
            dirg = new OverlayGraph(this.pid);
            if (needUndir) {
                undirg = fast ? new FastUndirGraph(dirg) : new ConstUndirGraph(dirg);
            }
            if (needReverse) {
                reverseg = new ReverseGraph(dirg);
            }
        }
        this.g = this.undir ? undirg : (this.reverse ? reverseg : dirg);
    }

    static {
        needUndir = false;
        needReverse = false;
    }
}

