/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import peernet.config.Configuration;
import peernet.graph.GraphIO;
import peernet.reports.GraphObserver;
import peernet.util.FileNameGenerator;

public class GraphPrinter
extends GraphObserver {
    private static final String PAR_BASENAME = "outf";
    private static final String PAR_FORMAT = "format";
    private final String baseName;
    private final FileNameGenerator fng;
    private final String format;

    public GraphPrinter(String name) {
        super(name);
        this.baseName = Configuration.getString(name + ".outf", null);
        this.format = Configuration.getString(name + ".format", "neighborlist");
        this.fng = this.baseName != null ? new FileNameGenerator(this.baseName, ".graph") : null;
    }

    @Override
    public boolean execute() {
        try {
            this.updateGraph();
            System.out.print(this.name + ": ");
            FileOutputStream fos = null;
            PrintStream pstr = System.out;
            if (this.baseName != null) {
                String fname = this.fng.nextCounterName();
                fos = new FileOutputStream(fname);
                System.out.println("writing to file " + fname);
                pstr = new PrintStream(fos);
            } else {
                System.out.println();
            }
            if (this.format.equals("neighborlist")) {
                GraphIO.writeNeighborList(this.g, pstr);
            } else if (this.format.equals("edgelist")) {
                GraphIO.writeEdgeList(this.g, pstr);
            } else if (this.format.equals("chaco")) {
                GraphIO.writeChaco(this.g, pstr);
            } else if (this.format.equals("netmeter")) {
                GraphIO.writeNetmeter(this.g, pstr);
            } else {
                System.err.println(this.name + ": unsupported format " + this.format);
            }
            if (fos != null) {
                fos.close();
            }
            return false;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

