/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import peernet.config.Configuration;
import peernet.graph.GraphAlgorithms;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;

public class GraphStats
extends GraphObserver {
    private static final String PAR_NL = "nl";
    private static final String PAR_NC = "nc";
    private final int nc;
    private final int nl;

    public GraphStats(String name) {
        super(name);
        this.nl = Configuration.getInt(name + ".nl", 0);
        this.nc = Configuration.getInt(name + ".nc", 0);
    }

    @Override
    public boolean execute() {
        int i;
        int n;
        this.startObservation();
        IncrementalStats stats = new IncrementalStats();
        this.updateGraph();
        if (this.nc != 0) {
            stats.reset();
            n = this.nc < 0 ? this.g.size() : this.nc;
            for (i = 0; i < n && i < this.g.size(); ++i) {
                stats.add(GraphAlgorithms.clustering(this.g, i));
            }
            this.output(stats.getAverage() + this.separator);
        }
        if (this.nl != 0) {
            stats.reset();
            n = this.nl < 0 ? this.g.size() : this.nl;
            block1: for (i = 0; i < n && i < this.g.size(); ++i) {
                this.ga.dist(this.g, i);
                for (int j = 0; j < this.g.size(); ++j) {
                    if (j == i) continue;
                    if (this.ga.d[j] == -1) {
                        stats.add(Double.POSITIVE_INFINITY);
                        break block1;
                    }
                    stats.add(this.ga.d[j]);
                }
            }
            this.output("" + stats.getAverage());
        }
        this.stopObservation();
        return false;
    }
}

