/*
 * Decompiled with CFR 0.152.
 */
package peernet.reports;

import java.util.Iterator;
import java.util.Map;
import peernet.config.Configuration;
import peernet.core.Network;
import peernet.graph.PrefixSubGraph;
import peernet.reports.GraphObserver;
import peernet.util.IncrementalStats;

public class RandRemoval
extends GraphObserver {
    private static final String PAR_N = "n";
    private final int n;

    public RandRemoval(String name) {
        super(name);
        this.n = Configuration.getInt(name + ".n", 1);
    }

    @Override
    public boolean execute() {
        int i;
        if (this.n <= 1) {
            return false;
        }
        this.startObservation();
        this.updateGraph();
        int size = Network.size();
        int steps = 50;
        IncrementalStats[] maxClust = new IncrementalStats[50];
        IncrementalStats[] clustNum = new IncrementalStats[50];
        for (i = 0; i < 50; ++i) {
            maxClust[i] = new IncrementalStats();
            clustNum[i] = new IncrementalStats();
        }
        for (int j = 0; j < this.n; ++j) {
            PrefixSubGraph sg = new PrefixSubGraph(this.g);
            IncrementalStats stats = new IncrementalStats();
            for (int i2 = 0; i2 < 50; ++i2) {
                sg.setSize(size / 2 - i2 * (size / 100));
                Map<Integer, Integer> clst = this.ga.weaklyConnectedClusters(sg);
                stats.reset();
                Iterator<Integer> it = clst.values().iterator();
                while (it.hasNext()) {
                    stats.add(it.next().intValue());
                }
                maxClust[i2].add(stats.getMax());
                clustNum[i2].add(clst.size());
            }
            if (j + 1 >= this.n) continue;
            Network.shuffle();
        }
        for (i = 0; i < 50; ++i) {
            this.output(maxClust[i].getAverage() + " " + clustNum[i].getAverage());
        }
        this.stopObservation();
        return false;
    }
}

