/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.StringTokenizer;
import peernet.config.Configuration;
import peernet.config.IllegalParameterException;
import peernet.core.Control;
import peernet.transport.RouterNetwork;

public class KingParser
implements Control {
    private static final String PAR_FILE = "file";
    private static final String PAR_TICKS_PER_SEC = "ticks_per_sec";
    private String filename;
    private double ratio;
    private String prefix;

    public KingParser(String prefix) {
        this.prefix = prefix;
        int ticks_per_sec = Configuration.getInt(prefix + ".ticks_per_sec");
        this.ratio = (double)ticks_per_sec / 1000000.0;
        this.filename = Configuration.getString(prefix + ".file", null);
    }

    @Override
    public boolean execute() {
        BufferedReader in = null;
        if (this.filename != null) {
            try {
                in = new BufferedReader(new FileReader(this.filename));
            }
            catch (FileNotFoundException e) {
                throw new IllegalParameterException(this.prefix + ".file", this.filename + " does not exist");
            }
        } else {
            in = new BufferedReader(new InputStreamReader(ClassLoader.getSystemResourceAsStream("t-king.map")));
        }
        String line = null;
        int size = 0;
        try {
            while ((line = in.readLine()) != null && !line.startsWith("node")) {
            }
            while (line != null && line.startsWith("node")) {
                ++size;
                line = in.readLine();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        RouterNetwork.reset(size, true);
        System.err.println("KingParser: read " + size + " entries");
        try {
            do {
                StringTokenizer tok = new StringTokenizer(line, ", ");
                int n1 = Integer.parseInt(tok.nextToken()) - 1;
                int n2 = Integer.parseInt(tok.nextToken()) - 1;
                int latency = (int)(Double.parseDouble(tok.nextToken()) * this.ratio);
                RouterNetwork.setLatency(n1, n2, latency);
            } while ((line = in.readLine()) != null);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

