/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.StringTokenizer;
import peernet.config.Configuration;
import peernet.core.Control;
import peernet.transport.RouterNetwork;

public class MatrixParser
implements Control {
    private static final String PAR_FILE = "file";
    private static final String PAR_SIM_TICKS_PER_SEC = "ticks_per_sec";
    private static final String PAR_TRACE_TICKS_PER_SEC = "trace_ticks_per_sec";
    private String filename;
    private String prefix;
    private double ratio;
    private boolean binary = false;

    public MatrixParser(String prefix) {
        this.prefix = prefix;
        this.filename = Configuration.getString(this.prefix + ".file");
        int ticks_per_sec = Configuration.getInt(this.prefix + ".ticks_per_sec");
        int trace_ticks_per_sec = Configuration.getInt(this.prefix + ".trace_ticks_per_sec");
        this.ratio = (double)ticks_per_sec / (double)trace_ticks_per_sec;
    }

    @Override
    public boolean execute() {
        try {
            if (this.binary) {
                MatrixParser.readBinaryFormat(this.filename, this.ratio);
            } else {
                MatrixParser.readAsciiFormat(this.filename, this.ratio);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }

    protected static void readAsciiFormat(String filename, double ratio) throws IOException {
        try (BufferedReader in = new BufferedReader(new FileReader(filename));){
            String line = in.readLine();
            int size = Integer.parseInt(line);
            RouterNetwork.reset(size, false);
            System.err.println("MatrixParser: reading latencies for " + size + " nodes");
            int count = 0;
            for (int row = 0; row < size; ++row) {
                line = in.readLine();
                assert (line != null);
                StringTokenizer tok = new StringTokenizer(line, " ");
                for (int col = 0; col < size; ++col) {
                    double latency = Double.parseDouble(tok.nextToken()) * ratio;
                    RouterNetwork.setLatency(row, col, latency >= 0.0 ? (int)latency : -1);
                    ++count;
                }
            }
            System.err.println("MatrixParser: Read " + count + " entries");
        }
    }

    protected static void readBinaryFormat(String filename, double ratio) throws IOException {
        try (DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(filename)));){
            System.err.println("MatrixParser: Reading file " + filename);
            int size = in.readInt();
            RouterNetwork.reset(size, true);
            System.err.println("MatrixParser: reading " + size + " rows");
            int count = 0;
            for (int row = 0; row < size; ++row) {
                for (int col = 0; col < size; ++col) {
                    int x = (int)(ratio * (double)in.readInt());
                    ++count;
                    RouterNetwork.setLatency(row, col, x);
                }
            }
            System.err.println("MatrixParser: Read " + count + " entries");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static void main(String[] args) throws IOException {
        MatrixParser.readAsciiFormat("/home/spyros/Data/latency/king_matrix", 1.0);
    }
}

