/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.util.Properties;
import peernet.config.Configuration;
import peernet.core.Engine;
import peernet.core.EngineAgent;
import peernet.core.Node;
import peernet.transport.Address;

public abstract class Transport
extends EngineAgent
implements Cloneable {
    private static final String PAR_TRANSPORT = "transport";
    private static final String defaultTransportSim = "peernet.transport.UniformRandomTransport";
    private static final String defaultTransportEmu = "peernet.transport.UniformRandomTransport";
    private static final String defaultTransportNet = "peernet.transport.TransportUDP";
    private static Transport defaultTransportInstance = null;

    public static Properties setDefaultTransports() {
        Properties p = new Properties();
        if (!Configuration.contains("sim.transport")) {
            p.setProperty("sim.transport", "peernet.transport.UniformRandomTransport");
        }
        if (!Configuration.contains("emu.transport")) {
            p.setProperty("emu.transport", "peernet.transport.UniformRandomTransport");
        }
        if (!Configuration.contains("net.transport")) {
            p.setProperty("net.transport", defaultTransportNet);
        }
        return p;
    }

    public abstract void send(Node var1, Address var2, int var3, Object var4);

    public Object clone() {
        Transport transport = null;
        try {
            transport = (Transport)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
        }
        return transport;
    }

    public static Transport defaultTransportInstance() {
        if (defaultTransportInstance == null) {
            String key = Engine.getType().toString().toLowerCase() + ".transport";
            if (Configuration.contains(key)) {
                defaultTransportInstance = (Transport)Configuration.getInstance(key);
            } else {
                switch (Engine.getType()) {
                    default: 
                }
            }
        }
        return defaultTransportInstance;
    }
}

