/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import peernet.config.Configuration;
import peernet.core.Engine;
import peernet.core.Node;
import peernet.transport.Address;
import peernet.transport.AddressSim;
import peernet.transport.Transport;

public class TransportEmu
extends Transport {
    private static final String PAR_LOCAL = "processing_delays";
    private int processingDelay;
    private Engine engine;

    public TransportEmu(String prefix) {
        this.processingDelay = Configuration.getInt(prefix + ".processing_delays", 0);
        this.engine = Engine.instance();
        assert (this.engine.getAddressType() == Engine.AddressType.SIM);
    }

    @Override
    public void send(Node src, Address dest, int pid, Object payload) {
        AddressSim senderAddress = new AddressSim(src);
        long latency = this.processingDelay;
        if (latency >= 0L) {
            this.addEventIn(latency, senderAddress, ((AddressSim)dest).node, pid, payload);
        }
    }

    @Override
    public Object clone() {
        return this;
    }
}

