/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import peernet.config.Configuration;
import peernet.core.Node;
import peernet.transport.Address;
import peernet.transport.AddressNet;
import peernet.transport.Packet;
import peernet.transport.TransportNet;

public class TransportUDP
extends TransportNet {
    private static final String PAR_PORT = "port";
    private DatagramSocket socket = null;
    private DatagramPacket dgram = null;
    private byte[] recvBuffer = null;
    private static Integer nextPort = -1;
    private static int initPort = -1;

    public TransportUDP(String prefix) {
        initPort = Configuration.getInt(prefix + ".port", -1);
        if (initPort != -1) {
            nextPort = initPort;
        }
        this.recvBuffer = new byte[65536];
    }

    @Override
    public void send(Node src, Address dest, int pid, Object payload) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(pid);
            oos.writeObject(payload);
            DatagramPacket datagramPacket = new DatagramPacket(baos.toByteArray(), baos.size(), ((AddressNet)dest).ip, ((AddressNet)dest).port);
            this.socket.send(datagramPacket);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public Packet receive() {
        try {
            this.socket.receive(this.dgram);
            ByteArrayInputStream bais = new ByteArrayInputStream(this.dgram.getData());
            ObjectInputStream ois = new ObjectInputStream(bais);
            AddressNet srcAddr = new AddressNet(this.dgram.getAddress(), this.dgram.getPort());
            int pid = (Integer)ois.readObject();
            Object event = ois.readObject();
            assert (srcAddr != null) : "TransportUDP.receive().srcAddr is null!";
            assert (event != null) : "TransportUDP.receive().event is null!";
            Packet packet = new Packet(srcAddr, pid, event);
            assert (packet != null) : "TransportUDP.receive().packet is null!";
            return packet;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            try {
                System.out.println("myhost=" + InetAddress.getLocalHost().getHostName());
            }
            catch (UnknownHostException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
            System.exit(-1);
        }
        return null;
    }

    @Override
    public InetAddress getAddress() {
        if (this.socket != null) {
            return this.socket.getInetAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.socket != null) {
            return this.socket.getLocalPort();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DatagramSocket bindNextLocalPort() {
        DatagramSocket socket = null;
        Integer n = nextPort;
        synchronized (n) {
            if (initPort < 0) {
                try {
                    socket = new DatagramSocket();
                }
                catch (SocketException e) {
                    socket = null;
                }
            } else {
                while (socket == null) {
                    try {
                        socket = new DatagramSocket(nextPort);
                    }
                    catch (SocketException e) {
                        Integer n2 = nextPort;
                        nextPort = nextPort + 1;
                        if (nextPort == 65536) {
                            nextPort = 1024;
                        }
                        if (nextPort != initPort) continue;
                        return null;
                    }
                }
                Integer n3 = nextPort;
                nextPort = nextPort + 1;
                if (nextPort == 65536) {
                    nextPort = 1024;
                }
            }
        }
        return socket;
    }

    @Override
    public Object clone() {
        TransportUDP trans = null;
        trans = (TransportUDP)super.clone();
        trans.socket = this.bindNextLocalPort();
        trans.recvBuffer = (byte[])this.recvBuffer.clone();
        trans.dgram = new DatagramPacket(trans.recvBuffer, trans.recvBuffer.length);
        return trans;
    }
}

