/*
 * Decompiled with CFR 0.152.
 */
package peernet.transport;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import peernet.config.Configuration;
import peernet.core.Control;
import peernet.transport.RouterNetwork;

public class TriangularMatrixParser
implements Control {
    private static final String PAR_FILE = "file";
    private static final String PAR_RATIO = "ratio";
    private String filename;
    private String prefix;
    private double ratio;

    public TriangularMatrixParser(String prefix) {
        this.prefix = prefix;
        this.filename = Configuration.getString(this.prefix + ".file");
        this.ratio = Configuration.getDouble(this.prefix + ".ratio");
    }

    @Override
    public boolean execute() {
        try {
            ObjectInputStream in = null;
            try {
                in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.filename)));
                System.err.println("TriangularMatrixParser: Reading " + this.filename + " from local file system");
            }
            catch (FileNotFoundException e) {
                in = new ObjectInputStream(new BufferedInputStream(ClassLoader.getSystemResourceAsStream(this.filename)));
                System.err.println("TriangularMatrixParser: Reading " + this.filename + " through the class loader");
            }
            int size = in.readInt();
            RouterNetwork.reset(size, true);
            System.err.println("TriangularMatrixParser: reading " + size + " rows");
            int count = 0;
            for (int r = 0; r < size; ++r) {
                for (int c = r + 1; c < size; ++c) {
                    int x = (int)(this.ratio * (double)in.readInt());
                    ++count;
                    RouterNetwork.setLatency(r, c, x);
                }
            }
            System.err.println("TriangularMatrixParser: Read " + count + " entries");
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        return false;
    }
}

