/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.util.Random;

public class ExtendedRandom
extends Random {
    private static final long serialVersionUID = -5633934413165672320L;
    private long lastSeed;

    public ExtendedRandom(long seed) {
        super(seed);
        this.lastSeed = seed;
    }

    public int nextPoisson(double mean) {
        double emean = Math.exp(-1.0 * mean);
        int count = 0;
        int result = 0;
        for (double product = 1.0; product >= emean; product *= this.nextDouble()) {
            result = count++;
        }
        return result;
    }

    @Override
    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive");
        }
        if ((n & -n) == n) {
            return this.nextLong() & n - 1L;
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public void setSeed(long seed) {
        super.setSeed(seed);
        this.lastSeed = seed;
    }

    public long getLastSeed() {
        return this.lastSeed;
    }
}

