/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.io.PrintStream;

public class IncrementalFreq
implements Cloneable {
    private int n;
    private int min;
    private int max;
    private double sum;
    private int[] freq = null;
    private final int N;

    public IncrementalFreq(int maxvalue) {
        this.N = maxvalue + 1;
        this.reset();
    }

    public IncrementalFreq() {
        this(-1);
    }

    public void reset() {
        if (this.freq == null || this.N == 0) {
            this.freq = new int[0];
        } else {
            for (int i = 0; i < this.freq.length; ++i) {
                this.freq[i] = 0;
            }
        }
        this.n = 0;
    }

    public final void add(int i) {
        this.add(i, 1);
    }

    public void add(int i, int k) {
        if (this.N > 0 && i >= this.N) {
            return;
        }
        if (i < 0 || k <= 0) {
            return;
        }
        this.n += k;
        if (i < this.min) {
            this.min = i;
        }
        if (i > this.max) {
            this.max = i;
        }
        this.sum += (double)(i * k);
        if (i >= this.freq.length) {
            int[] tmp = new int[i + 1];
            System.arraycopy(this.freq, 0, tmp, 0, this.freq.length);
            this.freq = tmp;
        }
        int n = i;
        this.freq[n] = this.freq[n] + k;
    }

    public int getN() {
        return this.n;
    }

    public int getFreq(int i) {
        if (i >= 0 && i < this.freq.length) {
            return this.freq[i];
        }
        return 0;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    public double getSum() {
        return this.sum;
    }

    public double getAverage() {
        return this.sum / (double)this.n;
    }

    public void remove(IncrementalFreq other, boolean strict) {
        int i;
        if (strict && other.freq.length > this.freq.length) {
            for (int i2 = other.freq.length - 1; i2 >= this.freq.length; --i2) {
                if (other.freq[i2] == 0) continue;
                throw new IllegalArgumentException();
            }
        }
        int minLength = Math.min(other.freq.length, this.freq.length);
        for (i = minLength - 1; i >= 0; --i) {
            if (strict && this.freq[i] < other.freq[i]) {
                throw new IllegalArgumentException();
            }
            int remove = Math.min(other.freq[i], this.freq[i]);
            this.n -= remove;
            int n = i;
            this.freq[n] = this.freq[n] - remove;
            this.sum -= (double)(i * remove);
        }
        this.min = Integer.MAX_VALUE;
        for (i = this.freq.length - 1; i >= 0; --i) {
            if (this.freq[i] <= 0) continue;
            this.max = i;
            break;
        }
        this.max = Integer.MIN_VALUE;
        for (i = 0; i < this.freq.length - 1; ++i) {
            if (this.freq[i] <= 0) continue;
            this.min = i;
            break;
        }
    }

    public void printAll(PrintStream out) {
        for (int i = 0; i < this.freq.length; ++i) {
            out.println(i + " " + this.freq[i]);
        }
    }

    public void print(PrintStream out) {
        for (int i = 0; i < this.freq.length; ++i) {
            if (this.freq[i] == 0) continue;
            out.println(i + " " + this.freq[i]);
        }
    }

    public String toString(String separator) {
        Object result = "";
        for (int i = 0; i < this.freq.length; ++i) {
            if (this.freq[i] == 0) continue;
            result = (String)result + "\n" + i + separator + this.freq[i];
        }
        return result;
    }

    public String toString() {
        Object result = "";
        for (int i = 0; i < this.freq.length; ++i) {
            if (this.freq[i] == 0) continue;
            result = (String)result + " (" + i + "," + this.freq[i] + ")";
        }
        return result;
    }

    public String toArithmeticExpression() {
        Object result = "";
        for (int i = this.freq.length - 1; i >= 0; --i) {
            if (this.freq[i] == 0) continue;
            result = (String)result + this.freq[i] + "*" + i + "+";
        }
        result = ((String)result).equals("") ? "(empty)" : ((String)result).substring(0, ((String)result).length() - 1);
        return result;
    }

    public Object clone() throws CloneNotSupportedException {
        IncrementalFreq result = (IncrementalFreq)super.clone();
        if (this.freq != null) {
            result.freq = (int[])this.freq.clone();
        }
        return result;
    }

    public boolean equals(Object obj) {
        int i;
        IncrementalFreq other = (IncrementalFreq)obj;
        int minlength = Math.min(other.freq.length, this.freq.length);
        for (i = minlength - 1; i >= 0; --i) {
            if (this.freq[i] == other.freq[i]) continue;
            return false;
        }
        if (this.freq.length > minlength) {
            other = this;
        }
        for (i = minlength; i < other.freq.length; ++i) {
            if (other.freq[i] == 0) continue;
            return false;
        }
        return true;
    }
}

