/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

public class IncrementalStats {
    private double min;
    private double max;
    private double sum;
    private double sqrsum;
    private int n;
    private int countmin;
    private int countmax;

    public IncrementalStats() {
        this.reset();
    }

    public void reset() {
        this.countmin = 0;
        this.countmax = 0;
        this.min = Double.POSITIVE_INFINITY;
        this.max = Double.NEGATIVE_INFINITY;
        this.sum = 0.0;
        this.sqrsum = 0.0;
        this.n = 0;
    }

    public final void add(double item) {
        this.add(item, 1);
    }

    public void add(double item, int k) {
        if (item < this.min) {
            this.min = item;
            this.countmin = 0;
        }
        if (item == this.min) {
            this.countmin += k;
        }
        if (item > this.max) {
            this.max = item;
            this.countmax = 0;
        }
        if (item == this.max) {
            this.countmax += k;
        }
        this.n += k;
        if (k == 1) {
            this.sum += item;
            this.sqrsum += item * item;
        } else {
            this.sum += item * (double)k;
            this.sqrsum += item * item * (double)k;
        }
    }

    public int getN() {
        return this.n;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public int getMaxCount() {
        return this.countmax;
    }

    public int getMinCount() {
        return this.countmin;
    }

    public double getSum() {
        return this.sum;
    }

    public double getSqrSum() {
        return this.sqrsum;
    }

    public double getAverage() {
        return this.sum / (double)this.n;
    }

    public double getVar() {
        double var = (double)this.n / (double)(this.n - 1) * (this.sqrsum / (double)this.n - this.getAverage() * this.getAverage());
        return var >= 0.0 ? var : 0.0;
    }

    public double getStD() {
        return Math.sqrt(this.getVar());
    }

    public String toString() {
        return this.min + " " + this.max + " " + this.n + " " + this.sum / (double)this.n + " " + this.getVar() + " " + this.countmin + " " + this.countmax;
    }

    public String toString(String separator) {
        return this.min + separator + this.max + separator + this.n + separator + this.sum / (double)this.n + separator + this.getVar() + separator + this.countmin + separator + this.countmax;
    }
}

