/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import peernet.util.IncrementalStats;

public class MomentStats
extends IncrementalStats {
    private double cubicsum;
    private double quadsum;

    public MomentStats() {
        this.reset();
    }

    @Override
    public void reset() {
        super.reset();
        this.quadsum = 0.0;
        this.cubicsum = 0.0;
    }

    @Override
    public void add(double item, int k) {
        for (int i = 0; i < k; ++i) {
            super.add(item, 1);
            this.cubicsum += item * item * item;
            this.quadsum += item * this.cubicsum;
        }
    }

    @Override
    public String toString() {
        return super.toString() + " " + this.getSkewness() + " " + this.getKurtosis();
    }

    public double getSkewness() {
        int n = this.getN();
        double m3 = (double)n / (double)(n - 1) * (this.cubicsum / (double)n - Math.pow(this.getAverage(), 3.0));
        return m3 / Math.pow(this.getStD(), 3.0);
    }

    public double getKurtosis() {
        int n = this.getN();
        double m4 = (double)n / (double)(n - 1) * (this.quadsum / (double)n - Math.pow(this.getAverage(), 4.0));
        return m4 / Math.pow(this.getStD(), 4.0) - 3.0;
    }
}

