/*
 * Decompiled with CFR 0.152.
 */
package peernet.util;

import java.util.ArrayList;
import java.util.List;

public class StringListParser {
    private StringListParser() {
    }

    public static String[] parseList(String s) {
        ArrayList<String> list = new ArrayList<String>();
        String[] tokens = s.split(",");
        for (int i = 0; i < tokens.length; ++i) {
            StringListParser.parseItem(list, tokens[i]);
        }
        return list.toArray(new String[list.size()]);
    }

    private static void parseItem(List<String> list, String item) {
        String[] array = item.split(":");
        if (array.length == 1) {
            StringListParser.parseSingleItem(list, item);
        } else if (array.length == 2) {
            StringListParser.parseRangeItem(list, array[0], array[1]);
        } else {
            throw new IllegalArgumentException("Element " + item + "should be formatted as <start>:<stop> or <value>");
        }
    }

    private static void parseSingleItem(List<String> list, String item) {
        list.add(item);
    }

    private static void parseRangeItem(List<String> list, String start, String stop) {
        try {
            boolean sum;
            long vinc;
            long vstop;
            long vstart = Long.parseLong(start);
            int pos = stop.indexOf("|*");
            if (pos >= 0) {
                vstop = Long.parseLong(stop.substring(0, pos));
                vinc = Long.parseLong(stop.substring(pos + 2));
                sum = false;
            } else {
                pos = stop.indexOf("|");
                if (pos >= 0) {
                    vstop = Long.parseLong(stop.substring(0, pos));
                    vinc = Long.parseLong(stop.substring(pos + 1));
                    sum = true;
                } else {
                    vstop = Long.parseLong(stop);
                    vinc = 1L;
                    sum = true;
                }
            }
            if (sum) {
                for (long i = vstart; i <= vstop; i += vinc) {
                    list.add("" + i);
                }
            } else {
                for (long i = vstart; i <= vstop; i *= vinc) {
                    list.add("" + i);
                }
            }
        }
        catch (NumberFormatException e) {
            boolean sum;
            double vinc;
            double vstop;
            double vstart = Double.parseDouble(start);
            int pos = stop.indexOf("|*");
            if (pos >= 0) {
                vstop = Double.parseDouble(stop.substring(0, pos));
                vinc = Double.parseDouble(stop.substring(pos + 2));
                sum = false;
            } else {
                pos = stop.indexOf("|");
                if (pos >= 0) {
                    vstop = Double.parseDouble(stop.substring(0, pos));
                    vinc = Double.parseDouble(stop.substring(pos + 1));
                    sum = true;
                } else {
                    vstop = Double.parseDouble(stop);
                    vinc = 1.0;
                    sum = true;
                }
            }
            if (sum) {
                for (double i = vstart; i <= vstop; i += vinc) {
                    list.add("" + i);
                }
            } else {
                for (double i = vstart; i <= vstop; i *= vinc) {
                    list.add("" + i);
                }
            }
        }
    }
}

